/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorSchemeImporter;
import com.intellij.application.options.colors.ImportHandler;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ColorSchemeActions
extends AbstractSchemeActions<EditorColorsScheme> {
    protected ColorSchemeActions(@NotNull AbstractSchemesPanel<EditorColorsScheme, ?> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/colors/ColorSchemeActions", "<init>"));
        }
        super(schemesPanel);
    }

    @Override
    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            importersNames.add(importHandler.getTitle());
        }
        importersNames.addAll(super.getSchemeImportersNames());
        return importersNames;
    }

    @Override
    protected void importScheme(@NotNull String importerName) {
        VirtualFile importSource;
        if (importerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/colors/ColorSchemeActions", "importScheme"));
        }
        if (this.tryImportWithImportHandler(importerName)) {
            return;
        }
        SchemeImporter<EditorColorsScheme> importer = SchemeImporterEP.getImporter(importerName, EditorColorsScheme.class);
        if (importer != null && (importSource = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.getSchemesPanel(), null, "Choose " + importerName)) != null) {
            if ("jar".equals(importSource.getExtension())) {
                this.importFromJar(this.getSchemesPanel().getToolbar(), importer, importSource);
            } else {
                this.doImport(importer, importSource);
            }
        }
    }

    private void doImport(@NotNull SchemeImporter<EditorColorsScheme> importer, @NotNull VirtualFile importSource) {
        if (importer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importer", "com/intellij/application/options/colors/ColorSchemeActions", "doImport"));
        }
        if (importSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSource", "com/intellij/application/options/colors/ColorSchemeActions", "doImport"));
        }
        try {
            EditorColorsScheme imported = (EditorColorsScheme)importer.importScheme(DefaultProjectFactory.getInstance().getDefaultProject(), importSource, (Scheme)this.getOptions().getSelectedScheme(), name2 -> {
                String newName = SchemeNameGenerator.getUniqueName(name2 != null ? name2 : "Unnamed", candidate -> this.getSchemesPanel().getModel().containsScheme((String)candidate, false));
                EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(EmptyColorScheme.INSTANCE);
                newScheme.setName(newName);
                newScheme.setDefaultMetaInfo(EmptyColorScheme.INSTANCE);
                return newScheme;
            });
            if (imported != null) {
                this.getOptions().addImportedScheme(imported);
                this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"settings.editor.scheme.import.success", (Object[])new Object[]{importSource.getPresentableUrl(), imported.getName()}), MessageType.INFO);
            }
        }
        catch (SchemeImportException e) {
            this.handleError(e, importSource);
        }
    }

    private void handleError(@NotNull SchemeImportException e, @NotNull VirtualFile importSource) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/ColorSchemeActions", "handleError"));
        }
        if (importSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importSource", "com/intellij/application/options/colors/ColorSchemeActions", "handleError"));
        }
        String details = e.getMessage();
        this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"settings.editor.scheme.import.failure", (Object[])new Object[]{importSource.getPresentableUrl()}) + (StringUtil.isEmpty((String)details) ? "" : "\n" + details), MessageType.ERROR);
    }

    private void importFromJar(@NotNull Component componentAbove, final @NotNull SchemeImporter<EditorColorsScheme> importer, @NotNull VirtualFile jarFile) {
        if (componentAbove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentAbove", "com/intellij/application/options/colors/ColorSchemeActions", "importFromJar"));
        }
        if (importer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importer", "com/intellij/application/options/colors/ColorSchemeActions", "importFromJar"));
        }
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "com/intellij/application/options/colors/ColorSchemeActions", "importFromJar"));
        }
        try {
            List<VirtualFile> schemeFiles = ColorSchemeActions.getSchemeFiles(jarFile);
            if (schemeFiles.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                this.doImport(importer, schemeFiles.iterator().next());
                return;
            }
            ArrayList<Pair> fileList = new ArrayList<Pair>(schemeFiles.size());
            for (VirtualFile file2 : schemeFiles) {
                Element root = SchemeImportUtil.loadSchemeDom(file2);
                String name2 = StringUtil.trimStart((String)ColorSchemeImporter.getSchemeName(root), (String)"_@user_");
                fileList.add(Pair.create((Object)name2, (Object)file2));
            }
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Pair<String, VirtualFile>>("Choose scheme to import", fileList){

                @NotNull
                public String getTextFor(Pair<String, VirtualFile> item) {
                    String string = (String)item.first;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/ColorSchemeActions$1", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(Pair<String, VirtualFile> selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (importer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importer", "com/intellij/application/options/colors/ColorSchemeActions$1", "lambda$onChosen$0"));
                        }
                        ColorSchemeActions.this.doImport((SchemeImporter<EditorColorsScheme>)importer, (VirtualFile)selectedValue.second);
                    });
                }
            });
            popup.showUnderneathOf(componentAbove);
        }
        catch (SchemeImportException e) {
            this.handleError(e, jarFile);
        }
    }

    private static List<VirtualFile> getSchemeFiles(@NotNull VirtualFile jarFile) throws SchemeImportException {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "com/intellij/application/options/colors/ColorSchemeActions", "getSchemeFiles"));
        }
        ArrayList<VirtualFile> schemeFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : jarFile.getChildren()) {
            if (!file2.isDirectory() || !"colors".equals(file2.getName())) continue;
            for (VirtualFile schemeFile : file2.getChildren()) {
                String ext = schemeFile.getExtension();
                if (!"icls".equals(ext) && !"xml".equals(ext)) continue;
                schemeFiles.add(schemeFile);
            }
            break;
        }
        if (schemeFiles.isEmpty()) {
            throw new SchemeImportException("The are no color schemes in the chosen file.");
        }
        return schemeFiles;
    }

    private boolean tryImportWithImportHandler(@NotNull String importerName) {
        if (importerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/colors/ColorSchemeActions", "tryImportWithImportHandler"));
        }
        for (ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            if (!importerName.equals(importHandler.getTitle())) continue;
            importHandler.performImport(this.getSchemesPanel().getToolbar(), (Consumer<EditorColorsScheme>)((Consumer)scheme2 -> {
                if (scheme2 != null) {
                    this.getOptions().addImportedScheme((EditorColorsScheme)scheme2);
                }
            }));
            return true;
        }
        return false;
    }

    @Override
    protected void resetScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorSchemeActions", "resetScheme"));
        }
        if (Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"color.scheme.reset.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"color.scheme.reset.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            this.getOptions().resetSchemeToOriginal(scheme2.getName());
        }
    }

    @Override
    protected void duplicateScheme(@NotNull EditorColorsScheme scheme2, @NotNull String newName) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorSchemeActions", "duplicateScheme"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/application/options/colors/ColorSchemeActions", "duplicateScheme"));
        }
        this.getOptions().saveSchemeAs(scheme2, newName);
    }

    @Override
    protected void exportScheme(@NotNull EditorColorsScheme scheme2, @NotNull String exporterName) {
        EditorColorsScheme parent;
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorSchemeActions", "exportScheme"));
        }
        if (exporterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporterName", "com/intellij/application/options/colors/ColorSchemeActions", "exportScheme"));
        }
        EditorColorsScheme schemeToExport = scheme2;
        if (scheme2 instanceof AbstractColorsScheme && !((parent = ((AbstractColorsScheme)scheme2).getParentScheme()) instanceof DefaultColorsScheme)) {
            schemeToExport = parent;
        }
        if (schemeToExport.getName().startsWith("_@user_")) {
            schemeToExport = (EditorColorsScheme)schemeToExport.clone();
            schemeToExport.setName(SchemeManager.getDisplayName((Scheme)schemeToExport));
        }
        super.exportScheme(schemeToExport, exporterName);
    }

    @Override
    protected Class<EditorColorsScheme> getSchemeType() {
        return EditorColorsScheme.class;
    }

    @NotNull
    protected abstract ColorAndFontOptions getOptions();
}

