/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.CustomizedSwitcherPanel;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;

public class NewColorAndFontPanel
extends JPanel {
    private final ColorSettingsPage mySettingsPage;
    private final SchemesPanel mySchemesPanel;
    private final OptionsPanel myOptionsPanel;
    private final PreviewPanel myPreviewPanel;
    private final String myCategory;
    private final Collection<String> myOptionList;

    public NewColorAndFontPanel(SchemesPanel schemesPanel, final OptionsPanel optionsPanel, final PreviewPanel previewPanel, String category, Collection<String> optionList, ColorSettingsPage page) {
        super(new BorderLayout(0, 10));
        this.mySchemesPanel = schemesPanel;
        this.myOptionsPanel = optionsPanel;
        this.myPreviewPanel = previewPanel;
        this.myCategory = category;
        this.myOptionList = optionList;
        this.mySettingsPage = page;
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.mySchemesPanel, "North");
        top.add((Component)this.myOptionsPanel.getPanel(), "Center");
        if (!(this.myPreviewPanel.getPanel() == null || page != null && StringUtil.isEmptyOrSpaces((String)page.getDemoText()))) {
            JSplitPane splitPane = new JSplitPane(0, top, this.myPreviewPanel.getPanel());
            splitPane.setBorder(BorderFactory.createEmptyBorder());
            splitPane.setContinuousLayout(true);
            this.add(splitPane);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPane);
        } else {
            this.add((Component)top, "Center");
        }
        previewPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void selectionInPreviewChanged(String typeToSelect) {
                optionsPanel.selectOption(typeToSelect);
            }
        });
        optionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void settingsChanged() {
                NewColorAndFontPanel.this.mySchemesPanel.updateOnCurrentSettingsChange();
                optionsPanel.applyChangesToScheme();
                previewPanel.updateView();
            }

            @Override
            public void selectedOptionChanged(Object selected) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    NewColorAndFontPanel.this.myPreviewPanel.blinkSelectedHighlightType(selected);
                }
            }
        });
        this.mySchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(Object source) {
                NewColorAndFontPanel.this.myOptionsPanel.updateOptionsList();
                NewColorAndFontPanel.this.myPreviewPanel.updateView();
            }
        });
    }

    public static NewColorAndFontPanel create(PreviewPanel previewPanel, String category, ColorAndFontOptions options, Collection<String> optionList, ColorSettingsPage page) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, category, new CustomizedSwitcherPanel(previewPanel, page));
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, category, optionList, page);
    }

    public Runnable showOption(String option) {
        return this.myOptionsPanel.showOption(option);
    }

    @NotNull
    public Set<String> processListOptions() {
        if (this.myOptionList == null) {
            Set<String> set2 = this.myOptionsPanel.processListOptions();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/NewColorAndFontPanel", "processListOptions"));
            }
            return set2;
        }
        HashSet<String> hashSet = new HashSet<String>(this.myOptionList);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/NewColorAndFontPanel", "processListOptions"));
        }
        return hashSet;
    }

    public String getDisplayName() {
        return this.myCategory;
    }

    public void reset(Object source) {
        this.resetSchemesCombo(source);
    }

    public void disposeUIResources() {
        this.myPreviewPanel.disposeUIResources();
    }

    public void addSchemesListener(ColorAndFontSettingsListener schemeListener) {
        this.mySchemesPanel.addListener(schemeListener);
    }

    private void resetSchemesCombo(Object source) {
        this.mySchemesPanel.resetSchemesCombo(source);
    }

    public boolean contains(EditorSchemeAttributeDescriptor descriptor) {
        return descriptor.getGroup().equals(this.myCategory);
    }

    public JComponent getPanel() {
        return this;
    }

    public void updatePreview() {
        this.myPreviewPanel.updateView();
    }

    public void updateSchemesPanel() {
        this.mySchemesPanel.updateOnCurrentSettingsChange();
    }

    public void addDescriptionListener(ColorAndFontSettingsListener listener2) {
        this.myOptionsPanel.addListener(listener2);
    }

    public boolean containsFontOptions() {
        return false;
    }

    public ColorSettingsPage getSettingsPage() {
        return this.mySettingsPage;
    }

    public void setEmptyText(@NotNull String text2, final @NotNull String details) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/colors/NewColorAndFontPanel", "setEmptyText"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/application/options/colors/NewColorAndFontPanel", "setEmptyText"));
        }
        this.myOptionsPanel.setEmptyText(text2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewColorAndFontPanel.this.notifyAtSchemePanel(details);
            }
        });
    }

    private void notifyAtSchemePanel(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/application/options/colors/NewColorAndFontPanel", "notifyAtSchemePanel"));
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        Balloon balloon = popupFactory.createHtmlTextBalloonBuilder(message2, MessageType.INFO, null).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)balloon);
        balloon.show(new RelativePoint((Component)this.mySchemesPanel, new Point(this.mySchemesPanel.getWidth() / 10, this.mySchemesPanel.getHeight())), Balloon.Position.below);
    }
}

