/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorTabsConfigurable
implements EditorOptionsProvider {
    private static final UINumericRange EDITOR_TABS_RANGE = new UINumericRange(10, 1, 100);
    private JPanel myRootPanel;
    private JCheckBox myHideKnownExtensions;
    private JCheckBox myScrollTabLayoutInEditorCheckBox;
    private JTextField myEditorTabLimitField;
    private JComboBox myEditorTabPlacement;
    private JRadioButton myCloseNonModifiedFilesFirstRadio;
    private JRadioButton myCloseLRUFilesRadio;
    private JRadioButton myActivateLeftEditorOnCloseRadio;
    private JRadioButton myActivateMRUEditorOnCloseRadio;
    private JCheckBox myCbModifiedTabsMarkedWithAsterisk;
    private JCheckBox myShowTabsTooltipsCheckBox;
    private JCheckBox myShowCloseButtonOnCheckBox;
    private JCheckBox myShowDirectoryInTabCheckBox;
    private JRadioButton myActivateRightNeighbouringTabRadioButton;
    private JCheckBox myHideTabsCheckbox;
    private JCheckBox myReuseNotModifiedTabsCheckBox;

    public EditorTabsConfigurable() {
        this.$$$setupUI$$$();
        this.myEditorTabPlacement.setModel(new DefaultComboBoxModel<Object>(new Object[]{1, 2, 3, 4, 0}));
        this.myEditorTabPlacement.setRenderer(new MyTabsPlacementComboBoxRenderer());
        this.myEditorTabPlacement.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EditorTabsConfigurable.this.revalidateSingleRowCheckbox();
            }
        });
        this.revalidateSingleRowCheckbox();
        this.myScrollTabLayoutInEditorCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                EditorTabsConfigurable.this.myHideTabsCheckbox.setEnabled(EditorTabsConfigurable.this.myScrollTabLayoutInEditorCheckBox.isSelected());
            }
        });
    }

    private void revalidateSingleRowCheckbox() {
        int i2 = (Integer)this.myEditorTabPlacement.getSelectedItem();
        boolean none = i2 == 0;
        this.myHideKnownExtensions.setEnabled(!none);
        this.myHideTabsCheckbox.setEnabled(!none && this.myScrollTabLayoutInEditorCheckBox.isSelected());
        this.myScrollTabLayoutInEditorCheckBox.setEnabled(!none);
        this.myCbModifiedTabsMarkedWithAsterisk.setEnabled(!none);
        this.myShowTabsTooltipsCheckBox.setEnabled(!none);
        this.myShowCloseButtonOnCheckBox.setEnabled(!none);
        this.myShowDirectoryInTabCheckBox.setEnabled(!none);
        if (1 == i2) {
            this.myScrollTabLayoutInEditorCheckBox.setEnabled(true);
        } else {
            this.myScrollTabLayoutInEditorCheckBox.setSelected(true);
            this.myScrollTabLayoutInEditorCheckBox.setEnabled(false);
        }
    }

    @Nls
    public String getDisplayName() {
        return "Editor Tabs";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.tabs";
    }

    public JComponent createComponent() {
        return this.myRootPanel;
    }

    public void reset() {
        UISettings uiSettings = UISettings.getInstance();
        this.myCbModifiedTabsMarkedWithAsterisk.setSelected(uiSettings.getMarkModifiedTabsWithAsterisk());
        this.myShowTabsTooltipsCheckBox.setSelected(uiSettings.getShowTabsTooltips());
        this.myScrollTabLayoutInEditorCheckBox.setSelected(uiSettings.getScrollTabLayoutInEditor());
        this.myHideTabsCheckbox.setEnabled(this.myScrollTabLayoutInEditorCheckBox.isSelected());
        this.myHideTabsCheckbox.setSelected(uiSettings.getHideTabsIfNeed());
        this.myEditorTabPlacement.setSelectedItem(uiSettings.getEditorTabPlacement());
        this.myHideKnownExtensions.setSelected(uiSettings.getHdeKnownExtensionInTabs());
        this.myShowDirectoryInTabCheckBox.setSelected(uiSettings.getShowDirectoryForNonUniqueFilenames());
        this.myEditorTabLimitField.setText(Integer.toString(uiSettings.getEditorTabLimit()));
        this.myReuseNotModifiedTabsCheckBox.setSelected(uiSettings.getReuseNotModifiedTabs());
        this.myShowCloseButtonOnCheckBox.setSelected(uiSettings.getShowCloseButton());
        if (uiSettings.getCloseNonModifiedFilesFirst()) {
            this.myCloseNonModifiedFilesFirstRadio.setSelected(true);
        } else {
            this.myCloseLRUFilesRadio.setSelected(true);
        }
        if (uiSettings.getActiveMruEditorOnClose()) {
            this.myActivateMRUEditorOnCloseRadio.setSelected(true);
        } else if (uiSettings.getActiveRightEditorOnClose()) {
            this.myActivateRightNeighbouringTabRadioButton.setSelected(true);
        } else {
            this.myActivateLeftEditorOnCloseRadio.setSelected(true);
        }
    }

    public void apply() throws ConfigurationException {
        UISettings uiSettings = UISettings.getInstance();
        boolean uiSettingsChanged = uiSettings.getMarkModifiedTabsWithAsterisk() != this.myCbModifiedTabsMarkedWithAsterisk.isSelected();
        uiSettings.setMarkModifiedTabsWithAsterisk(this.myCbModifiedTabsMarkedWithAsterisk.isSelected());
        if (this.isModified(this.myShowTabsTooltipsCheckBox, uiSettings.getShowTabsTooltips())) {
            uiSettingsChanged = true;
        }
        uiSettings.setShowTabsTooltips(this.myShowTabsTooltipsCheckBox.isSelected());
        if (this.isModified(this.myScrollTabLayoutInEditorCheckBox, uiSettings.getScrollTabLayoutInEditor())) {
            uiSettingsChanged = true;
        }
        uiSettings.setScrollTabLayoutInEditor(this.myScrollTabLayoutInEditorCheckBox.isSelected());
        if (this.isModified(this.myHideTabsCheckbox, uiSettings.getHideTabsIfNeed())) {
            uiSettingsChanged = true;
        }
        uiSettings.setHideTabsIfNeed(this.myHideTabsCheckbox.isSelected());
        if (this.isModified(this.myShowCloseButtonOnCheckBox, uiSettings.getShowCloseButton())) {
            uiSettingsChanged = true;
        }
        uiSettings.setShowCloseButton(this.myShowCloseButtonOnCheckBox.isSelected());
        int tabPlacement = (Integer)this.myEditorTabPlacement.getSelectedItem();
        if (uiSettings.getEditorTabPlacement() != tabPlacement) {
            uiSettingsChanged = true;
        }
        uiSettings.setEditorTabPlacement(tabPlacement);
        boolean hide = this.myHideKnownExtensions.isSelected();
        if (uiSettings.getHdeKnownExtensionInTabs() != hide) {
            uiSettingsChanged = true;
        }
        uiSettings.setHdeKnownExtensionInTabs(hide);
        boolean dir = this.myShowDirectoryInTabCheckBox.isSelected();
        if (uiSettings.getShowDirectoryForNonUniqueFilenames() != dir) {
            uiSettingsChanged = true;
        }
        uiSettings.setShowDirectoryForNonUniqueFilenames(dir);
        uiSettings.setCloseNonModifiedFilesFirst(this.myCloseNonModifiedFilesFirstRadio.isSelected());
        uiSettings.setActiveMruEditorOnClose(this.myActivateMRUEditorOnCloseRadio.isSelected());
        uiSettings.setActiveRightEditorOnClose(this.myActivateRightNeighbouringTabRadioButton.isSelected());
        if (this.isModified(this.myReuseNotModifiedTabsCheckBox, uiSettings.getReuseNotModifiedTabs())) {
            uiSettingsChanged = true;
        }
        uiSettings.setReuseNotModifiedTabs(this.myReuseNotModifiedTabsCheckBox.isSelected());
        if (this.isModified(this.myEditorTabLimitField, uiSettings.getEditorTabLimit(), EDITOR_TABS_RANGE)) {
            uiSettingsChanged = true;
        }
        try {
            uiSettings.setEditorTabLimit(EDITOR_TABS_RANGE.fit(Integer.parseInt(this.myEditorTabLimitField.getText().trim())));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
    }

    public boolean isModified() {
        UISettings uiSettings = UISettings.getInstance();
        boolean isModified = this.isModified(this.myCbModifiedTabsMarkedWithAsterisk, uiSettings.getMarkModifiedTabsWithAsterisk());
        isModified |= this.isModified(this.myShowTabsTooltipsCheckBox, uiSettings.getShowTabsTooltips());
        isModified |= EditorTabsConfigurable.isModified(this.myEditorTabLimitField, uiSettings.getEditorTabLimit());
        isModified |= this.isModified(this.myReuseNotModifiedTabsCheckBox, uiSettings.getReuseNotModifiedTabs());
        int tabPlacement = (Integer)this.myEditorTabPlacement.getSelectedItem();
        isModified |= tabPlacement != uiSettings.getEditorTabPlacement();
        isModified |= this.myHideKnownExtensions.isSelected() != uiSettings.getHdeKnownExtensionInTabs();
        isModified |= this.myShowDirectoryInTabCheckBox.isSelected() != uiSettings.getShowDirectoryForNonUniqueFilenames();
        isModified |= this.myScrollTabLayoutInEditorCheckBox.isSelected() != uiSettings.getScrollTabLayoutInEditor();
        isModified |= this.myHideTabsCheckbox.isSelected() != uiSettings.getHideTabsIfNeed();
        isModified |= this.myShowCloseButtonOnCheckBox.isSelected() != uiSettings.getShowCloseButton();
        isModified |= this.isModified(this.myCloseNonModifiedFilesFirstRadio, uiSettings.getCloseNonModifiedFilesFirst());
        isModified |= this.isModified(this.myActivateMRUEditorOnCloseRadio, uiSettings.getActiveMruEditorOnClose());
        return isModified |= this.isModified(this.myActivateRightNeighbouringTabRadioButton, uiSettings.getActiveRightEditorOnClose());
    }

    private static boolean isModified(JTextField textField, int value2) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.tabs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/editor/EditorTabsConfigurable", "getId"));
        }
        return "editor.preferences.tabs";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JComboBox jComboBox;
        JCheckBox jCheckBox8;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.tab.appearance"), (int)0, (int)0, null, null));
        this.myScrollTabLayoutInEditorCheckBox = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.editor.tabs.in.single.row"));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setIconTextGap(4);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.editor.tab.placement"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEditorTabPlacement = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 1, 0, new Dimension(140, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShowCloseButtonOnCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.editor.tabs.show.close.button"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCbModifiedTabsMarkedWithAsterisk = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.mark.modified.tabs.with.asterisk"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, new Dimension(239, 20), null));
        this.myHideKnownExtensions = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.hide.file.extension.in.editor.tabs"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myShowDirectoryInTabCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Show directory in editor tabs for non-unique filenames");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myShowTabsTooltipsCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.tabs.tooltips"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHideTabsCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.editor.scroll.if.need"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 10, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.tab.closing.policy"), (int)0, (int)0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.tab.limit"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(60, 27), null));
        this.myEditorTabLimitField = jTextField = new JTextField();
        jTextField.setText("15");
        jTextField.setColumns(2);
        jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myReuseNotModifiedTabsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.tab.reuse"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 2, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.when.number.of.opened.editors.exceeds.tab.limit"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCloseNonModifiedFilesFirstRadio = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.close.non.modified.files.first"));
        jPanel6.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCloseLRUFilesRadio = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.close.less.frequently.used.files"));
        jPanel6.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 0, 0, 0), -1, 2, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.when.closing.active.editor"));
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myActivateLeftEditorOnCloseRadio = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.activate.left.neighbouring.tab"));
        jPanel7.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myActivateMRUEditorOnCloseRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.activate.most.recently.opened.tab"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myActivateRightNeighbouringTabRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.activate.right.neighbouring.tab"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton5);
        buttonGroup2.add(jRadioButton4);
        buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class MyTabsPlacementComboBoxRenderer
    extends ListCellRendererWrapper<Integer> {
        public void customize(JList list2, Integer value2, int index, boolean selected, boolean hasFocus) {
            String text2;
            int tabPlacement = value2;
            if (0 == tabPlacement) {
                text2 = ApplicationBundle.message((String)"combobox.tab.placement.none", (Object[])new Object[0]);
            } else if (1 == tabPlacement) {
                text2 = ApplicationBundle.message((String)"combobox.tab.placement.top", (Object[])new Object[0]);
            } else if (2 == tabPlacement) {
                text2 = ApplicationBundle.message((String)"combobox.tab.placement.left", (Object[])new Object[0]);
            } else if (3 == tabPlacement) {
                text2 = ApplicationBundle.message((String)"combobox.tab.placement.bottom", (Object[])new Object[0]);
            } else if (4 == tabPlacement) {
                text2 = ApplicationBundle.message((String)"combobox.tab.placement.right", (Object[])new Object[0]);
            } else {
                throw new IllegalArgumentException("unknown tabPlacement: " + tabPlacement);
            }
            this.setText(text2);
        }
    }
}

