/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.text.CharSequenceReader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create((String)"EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotationsCache;
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache;
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStampCache;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<PsiModifierListOwner, AnnotationData> cache;
    private final CharTableImpl charTable;
    private static final JavaParserUtil.ParserWrapper ANNOTATION = JavaParser.INSTANCE.getDeclarationParser()::parseAnnotation;

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "<init>"));
        }
        this.myExternalAnnotationsCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        this.myAnnotationDataCache = new WeakKeyWeakValueHashMap();
        this.myAnnotationFileToDataAndModStampCache = ContainerUtil.createConcurrentSoftMap();
        this.cache = new ConcurrentMostlySingularMultiMap();
        this.charTable = new CharTableImpl();
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(this::dropCache, (Disposable)psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getExternalName"));
        }
        return PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)showParamName, (int)Integer.MAX_VALUE);
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "hasAnnotationRootsForFile"));
        }
        return this.hasAnyAnnotationsRoots();
    }

    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotation"));
        }
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotation"));
        }
        List<AnnotationData> list2 = this.collectExternalAnnotations(listOwner);
        AnnotationData data = BaseExternalAnnotationsManager.findByFQN(list2, annotationFQN);
        return data == null ? null : data.getAnnotation(this);
    }

    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotationWritable"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "isExternalAnnotationWritable"));
        }
        List<AnnotationData> map2 = this.doCollect(listOwner, true);
        return BaseExternalAnnotationsManager.findByFQN(map2, annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, @NotNull String annotationFQN) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findByFQN"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findByFQN"));
        }
        return (AnnotationData)ContainerUtil.find(map2, data -> {
            if (annotationFQN == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "lambda$findByFQN$0"));
            }
            return ((AnnotationData)data).annotationClassFqName.equals(annotationFQN);
        });
    }

    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotations"));
        }
        List<AnnotationData> result2 = this.collectExternalAnnotations(listOwner);
        return result2.isEmpty() ? null : (PsiAnnotation[])ContainerUtil.map2Array(result2, (Object[])PsiAnnotation.EMPTY_ARRAY, data -> data.getAnnotation(this));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
        }
        if (!this.hasAnyAnnotationsRoots()) {
            List<AnnotationData> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
            }
            return list2;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get((Object)listOwner)) != NO_DATA && cached.isEmpty()) continue;
            List<AnnotationData> list3 = cached;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
            }
            return list3;
        } while (!this.cache.replace((Object)listOwner, (Collection)cached, computed = this.doCollect(listOwner, false)));
        cached = computed;
        List<AnnotationData> list4 = cached;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "collectExternalAnnotations"));
        }
        return list4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "internAnnotationData"));
        }
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        // MONITORENTER : map2
        AnnotationData interned = this.myAnnotationDataCache.get(data);
        if (interned == null) {
            this.myAnnotationDataCache.put(data, data);
            interned = data;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map2
        if (annotationData != null) return annotationData;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "internAnnotationData"));
    }

    @NotNull
    public MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
        }
        Pair cached = (Pair)this.myAnnotationFileToDataAndModStampCache.get(file2);
        long fileModificationStamp = file2.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            MostlySingularMultiMap mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
            }
            return mostlySingularMultiMap;
        }
        DataParsingSaxHandler handler2 = new DataParsingSaxHandler(file2);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource((Reader)new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(file2.getViewProvider().getContents()))), (DefaultHandler)handler2);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(file2.getViewProvider().getVirtualFile().getPath(), (Throwable)e);
        }
        MostlySingularMultiMap<String, AnnotationData> result2 = handler2.getResult();
        this.myAnnotationFileToDataAndModStampCache.put(file2, (Pair<MostlySingularMultiMap<String, AnnotationData>, Long>)Pair.create(result2, (Object)fileModificationStamp));
        MostlySingularMultiMap<String, AnnotationData> mostlySingularMultiMap = result2;
        if (mostlySingularMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "getDataFromFile"));
        }
        return mostlySingularMultiMap;
    }

    protected void duplicateError(@NotNull PsiFile file2, @NotNull String externalName, @NotNull String text2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "duplicateError"));
        }
        LOG.error(text2 + "; for signature: '" + externalName + "' in the " + file2.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "intern"));
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = this.charTable.doIntern(annotationFQN).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "intern"));
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
        }
        List<PsiFile> files = this.findExternalAnnotationsFiles(listOwner);
        if (files == null) {
            List<AnnotationData> list2 = NO_DATA;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list2;
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner, false);
        if (externalName == null) {
            List<AnnotationData> list3 = NO_DATA;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list3;
        }
        SmartList result2 = new SmartList();
        for (PsiFile file2 : files) {
            if (!file2.isValid() || onlyWritable && !file2.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file2);
            ContainerUtil.addAll((Collection)result2, (Iterable)fileData.get((Object)externalName));
        }
        if (result2.isEmpty()) {
            List<AnnotationData> list4 = NO_DATA;
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
            }
            return list4;
        }
        result2.trimToSize();
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "doCollect"));
        }
        return smartList;
    }

    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "findExternalAnnotationsFiles"));
        }
        PsiFile containingFile = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner).getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotationsCache.get(virtualFile);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (Object file2 : files) {
                if (file2.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files;
            }
        }
        THashSet possibleAnnotationXmls = new THashSet();
        String relativePath = ((PsiJavaFile)containingFile).getPackageName().replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationXmls.add(psiFile);
        }
        if (possibleAnnotationXmls.isEmpty()) {
            this.myExternalAnnotationsCache.put(virtualFile, NULL_LIST);
            return null;
        }
        SmartList result2 = new SmartList((Collection)possibleAnnotationXmls);
        result2.sort((f1, f2) -> {
            boolean w2;
            boolean w1 = f1.isWritable();
            return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
        });
        this.myExternalAnnotationsCache.put(virtualFile, (List<PsiFile>)result2);
        return result2;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotationsCache.clear();
        this.myAnnotationFileToDataAndModStampCache.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        if (invalidXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidXml", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "escapeAttributes"));
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i2 = 0; i2 < invalidXml.length(); ++i2) {
            char c = invalidXml.charAt(i2);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        StringBuilder stringBuilder = buf;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "escapeAttributes"));
        }
        return stringBuilder;
    }

    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        if (annotationFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "annotateExternally"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "deannotate"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "deannotate"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value2) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "editExternalAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "editExternalAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "chooseAnnotationsPlace"));
        }
        throw new UnsupportedOperationException();
    }

    void cacheExternalAnnotations(@NotNull String packageName, @NotNull PsiFile fromFile, @NotNull List<PsiFile> annotationFiles) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        if (annotationFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFiles", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "cacheExternalAnnotations"));
        }
        VirtualFile virtualFile = fromFile.getVirtualFile();
        if (virtualFile != null) {
            this.myExternalAnnotationsCache.put(virtualFile, annotationFiles);
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "markAsExternalAnnotation"));
        }
        annotation.putUserData(EXTERNAL_ANNO_MARKER, (Object)Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "createAnnotationFromText"));
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text2, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text2 + "\".");
        }
        PsiAnnotation psiAnnotation = BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager", "createAnnotationFromText"));
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData = new MostlySingularMultiMap();
        private final PsiFile myFile;
        private String myExternalName;
        private String myAnnotationFqn;
        private StringBuilder myArguments;

        private DataParsingSaxHandler(PsiFile file2) {
            this.myFile = file2;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name2;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name2 = attributes.getValue("name")) != null) {
                    this.myArguments.append(name2);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                String argumentsString = this.myArguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.myArguments.toString());
                for (AnnotationData existingData : this.myData.get((Object)this.myExternalName)) {
                    if (!existingData.annotationClassFqName.equals(this.myAnnotationFqn)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                AnnotationData data = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add((Object)this.myExternalName, (Object)BaseExternalAnnotationsManager.this.internAnnotationData(data));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.myData.compact();
            return this.myData;
        }
    }

    public static class AnnotationData {
        private final String annotationClassFqName;
        private final String annotationParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters2) {
            if (fqn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "<init>"));
            }
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "<init>"));
            }
            this.annotationClassFqName = fqn;
            this.annotationParameters = parameters2;
        }

        @NotNull
        public PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "getAnnotation"));
            }
            PsiAnnotation a = this.myAnnotation;
            if (a == null) {
                String text2 = "@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")");
                this.myAnnotation = a = context.createAnnotationFromText(text2);
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData", "getAnnotation"));
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters);
        }

        public int hashCode() {
            int result2 = this.annotationClassFqName.hashCode();
            result2 = 31 * result2 + this.annotationParameters.hashCode();
            return result2;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }
    }
}

