/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.MakeExternalAnnotationExplicit;
import com.intellij.codeInsight.MakeInferredAnnotationExplicit;
import com.intellij.codeInsight.ToggleSourceInferredAnnotations;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.AddAnnotationIntention;
import com.intellij.codeInsight.intention.impl.DeannotateIntentionAction;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.NonCodeAnnotationGenerator;
import com.intellij.codeInspection.dataFlow.EditContractIntention;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Function<PsiElement, String> ourTooltipProvider = nameIdentifier -> {
        PsiModifierListOwner owner2 = (PsiModifierListOwner)nameIdentifier.getParent();
        return XmlStringUtil.wrapInHtml((CharSequence)(NonCodeAnnotationGenerator.getNonCodeHeader(NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(owner2).values()) + ". Full signature:<p>\n" + JavaDocInfoGenerator.generateSignature((PsiElement)owner2)));
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "getLineMarkerInfo"));
        }
        PsiModifierListOwner owner2 = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(element);
        if (owner2 == null) {
            return null;
        }
        boolean includeSourceInferred = CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS;
        boolean hasAnnotationsToShow = ContainerUtil.exists((Iterable)NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(owner2).values(), a -> includeSourceInferred || !a.isInferredFromSource());
        if (!hasAnnotationsToShow) {
            return null;
        }
        return new LineMarkerInfo(element, element.getTextRange(), AllIcons.Gutter.ExtAnnotation, 11, ourTooltipProvider, (GutterIconNavigationHandler)MyIconGutterHandler.INSTANCE, GutterIconRenderer.Alignment.RIGHT);
    }

    @Nullable
    static PsiModifierListOwner getAnnotationOwner(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement owner2 = element.getParent();
        if (!(owner2 instanceof PsiModifierListOwner) || !(owner2 instanceof PsiNameIdentifierOwner)) {
            return null;
        }
        if (owner2 instanceof PsiParameter || owner2 instanceof PsiLocalVariable) {
            return null;
        }
        PsiElement nameIdentifier = ((PsiNameIdentifierOwner)owner2).getNameIdentifier();
        if (nameIdentifier == null || !nameIdentifier.getTextRange().equals((Object)element.getTextRange())) {
            return null;
        }
        return (PsiModifierListOwner)owner2;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    @NotNull
    public String getName() {
        if ("External annotations" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "getName"));
        }
        return "External annotations";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.ExtAnnotation;
    }

    private static class MyIconGutterHandler
    implements GutterIconNavigationHandler<PsiElement> {
        static final MyIconGutterHandler INSTANCE = new MyIconGutterHandler();

        private MyIconGutterHandler() {
        }

        public void navigate(MouseEvent e, PsiElement nameIdentifier) {
            Project project2;
            Editor editor;
            PsiElement listOwner = nameIdentifier.getParent();
            PsiFile containingFile = listOwner.getContainingFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)listOwner);
            if (virtualFile != null && containingFile != null && (editor = FileEditorManager.getInstance((Project)(project2 = listOwner.getProject())).getSelectedTextEditor()) != null) {
                JBPopup popup;
                editor.getCaretModel().moveToOffset(nameIdentifier.getTextOffset());
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                if (file2 != null && virtualFile.equals(file2.getVirtualFile()) && (popup = this.createActionGroupPopup(containingFile, project2, editor)) != null) {
                    popup.show(new RelativePoint(e));
                }
            }
        }

        @Nullable
        protected JBPopup createActionGroupPopup(PsiFile file2, Project project2, Editor editor) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
                if (!MyIconGutterHandler.shouldShowInGutterPopup(action) || !action.isAvailable(project2, editor, file2)) continue;
                group.add((AnAction)new ApplyIntentionAction(action, action.getText(), editor, file2));
            }
            if (group.getChildrenCount() > 0) {
                DataContext context = SimpleDataContext.getProjectContext(null);
                return JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            }
            return null;
        }

        private static boolean shouldShowInGutterPopup(IntentionAction action) {
            return action instanceof AddAnnotationIntention || action instanceof DeannotateIntentionAction || action instanceof EditContractIntention || action instanceof ToggleSourceInferredAnnotations || action instanceof MakeInferredAnnotationExplicit || action instanceof MakeExternalAnnotationExplicit || action instanceof IntentionActionDelegate && MyIconGutterHandler.shouldShowInGutterPopup(((IntentionActionDelegate)action).getDelegate());
        }
    }
}

