/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.dataFlow.ContractInference;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullityInference;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.PurityInference;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferredAnnotationsManagerImpl
extends InferredAnnotationsManager {
    private static final Set<String> INFERRED_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{"org.jetbrains.annotations.NotNull", "org.jetbrains.annotations.Nullable", ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT});
    private final Project myProject;

    public InferredAnnotationsManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        PsiAnnotation anno;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotation"));
        }
        if (!INFERRED_ANNOTATIONS.contains(annotationFQN)) {
            return null;
        }
        listOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner);
        if (ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && listOwner instanceof PsiMethod && (anno = this.getHardcodedContractAnnotation((PsiMethod)listOwner)) != null) {
            return anno;
        }
        if (this.ignoreInference(listOwner, annotationFQN)) {
            return null;
        }
        PsiAnnotation fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotation(listOwner, annotationFQN);
        if (fromBytecode != null) {
            return fromBytecode;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotationFQN) || "org.jetbrains.annotations.Nullable".equals(annotationFQN)) {
            PsiAnnotation anno2 = null;
            if (listOwner instanceof PsiMethodImpl) {
                anno2 = this.getInferredNullityAnnotation((PsiMethodImpl)listOwner);
            }
            if (listOwner instanceof PsiParameter) {
                anno2 = this.getInferredNullityAnnotation((PsiParameter)listOwner);
            }
            return anno2 == null ? null : (annotationFQN.equals(anno2.getQualifiedName()) ? anno2 : null);
        }
        if (listOwner instanceof PsiMethodImpl && ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN)) {
            return this.getInferredContractAnnotation((PsiMethodImpl)listOwner);
        }
        return null;
    }

    @Nullable
    private PsiAnnotation getHardcodedContractAnnotation(PsiMethod method) {
        List<MethodContract> contracts2 = HardcodedContracts.getHardcodedContracts(method, null);
        return contracts2.isEmpty() ? null : this.createContractAnnotation(contracts2, HardcodedContracts.isHardcodedPure(method));
    }

    public boolean ignoreInference(@NotNull PsiModifierListOwner owner2, @Nullable String annotationFQN) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "ignoreInference"));
        }
        if (owner2 instanceof PsiMethod && PsiUtil.canBeOverriden((PsiMethod)((PsiMethod)owner2))) {
            return true;
        }
        if (ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotationFQN) && HardcodedContracts.hasHardcodedContracts((PsiElement)owner2)) {
            return true;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotationFQN) && owner2 instanceof PsiParameter && owner2.getParent() != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner2, (Collection)NullableNotNullManager.getInstance((Project)owner2.getProject()).getNullables(), (boolean)false, (boolean)false)) {
                return true;
            }
            if (HardcodedContracts.hasHardcodedContracts((PsiElement)owner2)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private PsiAnnotation getInferredContractAnnotation(PsiMethodImpl method) {
        if (method.getModifierList().findAnnotation(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT) != null) {
            return null;
        }
        return this.createContractAnnotation(ContractInference.inferContracts(method), PurityInference.inferPurity(method));
    }

    @Nullable
    private PsiAnnotation getInferredNullityAnnotation(PsiMethodImpl method) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)manager.getNotNulls(), (boolean)true) != null || AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)manager.getNullables(), (boolean)true) != null) {
            return null;
        }
        if (NullableNotNullManager.findNullabilityDefaultInHierarchy((PsiModifierListOwner)method, (boolean)true) != null || NullableNotNullManager.findNullabilityDefaultInHierarchy((PsiModifierListOwner)method, (boolean)false) != null) {
            return null;
        }
        Nullness nullness = NullityInference.inferNullity(method);
        if (nullness == Nullness.NOT_NULL) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        if (nullness == Nullness.NULLABLE) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNullableAnnotation();
        }
        return null;
    }

    private PsiAnnotation getInferredNullityAnnotation(PsiParameter parameter) {
        String className;
        PsiClass containingClass;
        PsiMethod method;
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof PsiParameterList)) {
            return null;
        }
        PsiElement scope = parent.getParent();
        if (scope instanceof PsiMethod && (method = (PsiMethod)scope).getName().equals("of") && (containingClass = method.getContainingClass()) != null && ("java.util.List".equals(className = containingClass.getQualifiedName()) || "java.util.Set".equals(className) || "java.util.Map".equals(className) || "java.util.EnumSet".equals(className))) {
            return ProjectBytecodeAnalysis.getInstance(this.myProject).getNotNullAnnotation();
        }
        return null;
    }

    @Nullable
    private PsiAnnotation createContractAnnotation(List<? extends MethodContract> contracts2, boolean pure) {
        return InferredAnnotationsManagerImpl.createContractAnnotation(this.myProject, pure, StreamEx.of(contracts2).select(StandardMethodContract.class).joining((CharSequence)"; "));
    }

    @Nullable
    public static PsiAnnotation createContractAnnotation(Project project2, boolean pure, String contracts2) {
        String attrs;
        if (!contracts2.isEmpty() && pure) {
            attrs = "value = \"" + contracts2 + "\", pure = true";
        } else if (pure) {
            attrs = "pure = true";
        } else if (!contracts2.isEmpty()) {
            attrs = "\"" + contracts2 + "\"";
        } else {
            return null;
        }
        return ProjectBytecodeAnalysis.getInstance(project2).createContractAnnotation(attrs);
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        PsiAnnotation[] fromBytecode;
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotations"));
        }
        listOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiAnnotation annotation : fromBytecode = ProjectBytecodeAnalysis.getInstance(this.myProject).findInferredAnnotations(listOwner)) {
            if (this.ignoreInference(listOwner, annotation.getQualifiedName())) continue;
            result2.add(annotation);
        }
        if (listOwner instanceof PsiMethod) {
            PsiAnnotation hardcoded = this.getHardcodedContractAnnotation((PsiMethod)listOwner);
            if (hardcoded != null) {
                result2.add(hardcoded);
            }
            if (listOwner instanceof PsiMethodImpl) {
                PsiAnnotation annotation;
                if (hardcoded == null && !this.ignoreInference(listOwner, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)this.getInferredContractAnnotation((PsiMethodImpl)listOwner));
                }
                if (!(this.ignoreInference(listOwner, "org.jetbrains.annotations.NotNull") && this.ignoreInference(listOwner, "org.jetbrains.annotations.Nullable") || (annotation = this.getInferredNullityAnnotation((PsiMethodImpl)listOwner)) == null || this.ignoreInference(listOwner, annotation.getQualifiedName()))) {
                    result2.add(annotation);
                }
            }
        }
        PsiAnnotation[] psiAnnotationArray = result2.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "findInferredAnnotations"));
        }
        return psiAnnotationArray;
    }

    public boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/InferredAnnotationsManagerImpl", "isInferredAnnotation"));
        }
        return annotation.getUserData(ProjectBytecodeAnalysis.INFERRED_ANNOTATION) != null;
    }
}

