/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JavaProjectCodeInsightSettings", storages={@Storage(value="codeInsightSettings.xml")})
public class JavaProjectCodeInsightSettings
implements PersistentStateComponent<JavaProjectCodeInsightSettings> {
    private static final ConcurrentWeakFactoryMap<String, Pattern> ourPatterns = new ConcurrentWeakFactoryMap<String, Pattern>(){

        @Nullable
        protected Pattern create(String key2) {
            return PatternUtil.fromMask((String)key2);
        }
    };
    @Tag(value="excluded-names")
    @AbstractCollection(surroundWithTag=false, elementTag="name", elementValueAttribute="")
    public List<String> excludedNames = ContainerUtil.newArrayList();

    public static JavaProjectCodeInsightSettings getSettings(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "getSettings"));
        }
        return (JavaProjectCodeInsightSettings)ServiceManager.getService((Project)project2, JavaProjectCodeInsightSettings.class);
    }

    public boolean isExcluded(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "isExcluded"));
        }
        for (String excluded : this.excludedNames) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name2, excluded)) continue;
            return true;
        }
        for (String excluded : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name2, excluded)) continue;
            return true;
        }
        return false;
    }

    private static boolean nameMatches(@NotNull String name2, String excluded) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "nameMatches"));
        }
        int length = JavaProjectCodeInsightSettings.getMatchingLength(name2, excluded);
        return length > 0 && (name2.length() == length || name2.charAt(length) == '.');
    }

    private static int getMatchingLength(@NotNull String name2, String excluded) {
        Matcher matcher;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "getMatchingLength"));
        }
        if (name2.startsWith(excluded)) {
            return excluded.length();
        }
        if (excluded.indexOf(42) >= 0 && (matcher = ((Pattern)ourPatterns.get((Object)excluded)).matcher(name2)).lookingAt()) {
            return matcher.end();
        }
        return -1;
    }

    @Nullable
    public JavaProjectCodeInsightSettings getState() {
        return this;
    }

    public void loadState(JavaProjectCodeInsightSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static void setExcludedNames(Project project2, Disposable parentDisposable, String ... excludes) {
        final JavaProjectCodeInsightSettings instance = JavaProjectCodeInsightSettings.getSettings(project2);
        assert (instance.excludedNames.isEmpty());
        instance.excludedNames = Arrays.asList(excludes);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance.excludedNames = ContainerUtil.newArrayList();
            }
        });
    }
}

