/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerNotNullableSerializer;

@State(name="NullableNotNullManager")
public class NullableNotNullManagerImpl
extends NullableNotNullManager
implements PersistentStateComponent<Element> {
    public static final String TYPE_QUALIFIER_NICKNAME = "javax.annotation.meta.TypeQualifierNickname";

    public NullableNotNullManagerImpl(Project project2) {
        super(project2);
        this.myNotNulls.addAll(this.getPredefinedNotNulls());
    }

    public List<String> getPredefinedNotNulls() {
        return JpsJavaCompilerNotNullableSerializer.DEFAULT_NOT_NULLS;
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return HardcodedContracts.hasHardcodedContracts(element);
    }

    public Element getState() {
        Element component = new Element("component");
        if (this.hasDefaultValues()) {
            return component;
        }
        try {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)component);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return component;
    }

    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)state);
            if (this.myNullables.isEmpty()) {
                Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
            }
            if (this.myNotNulls.isEmpty()) {
                this.myNotNulls.addAll(this.getPredefinedNotNulls());
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    private List<PsiClass> getAllNullabilityNickNames() {
        if (!this.getNotNulls().contains("javax.annotation.Nonnull")) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ArrayList result2 = new ArrayList();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            for (PsiClass tqNick : JavaPsiFacade.getInstance((Project)this.myProject).findClasses(TYPE_QUALIFIER_NICKNAME, scope)) {
                result2.addAll(ContainerUtil.findAll((Collection)MetaAnnotationUtil.getChildren((PsiClass)tqNick, (GlobalSearchScope)scope), candidate -> {
                    String qname = candidate.getQualifiedName();
                    if (qname == null || qname.startsWith("javax.annotation.")) {
                        return false;
                    }
                    return NullableNotNullManagerImpl.getNickNamedNullability(candidate) != Nullness.UNKNOWN;
                }));
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static Nullness getNickNamedNullability(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/NullableNotNullManagerImpl", "getNickNamedNullability"));
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{TYPE_QUALIFIER_NICKNAME}) == null) {
            return Nullness.UNKNOWN;
        }
        PsiAnnotation nonNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.annotation.Nonnull"});
        return nonNull != null ? NullableNotNullManagerImpl.extractNullityFromWhenValue(nonNull) : Nullness.UNKNOWN;
    }

    @NotNull
    private static Nullness extractNullityFromWhenValue(PsiAnnotation nonNull) {
        PsiAnnotationMemberValue when = nonNull.findAttributeValue("when");
        if (when instanceof PsiReferenceExpression) {
            String refName = ((PsiReferenceExpression)when).getReferenceName();
            if ("ALWAYS".equals(refName)) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManagerImpl", "extractNullityFromWhenValue"));
                }
                return nullness;
            }
            if ("MAYBE".equals(refName) || "NEVER".equals(refName)) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManagerImpl", "extractNullityFromWhenValue"));
                }
                return nullness;
            }
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManagerImpl", "extractNullityFromWhenValue"));
        }
        return nullness;
    }

    private List<String> filterNickNames(Nullness nullness) {
        return ((StreamEx)StreamEx.of(this.getAllNullabilityNickNames()).filter(c -> NullableNotNullManagerImpl.getNickNamedNullability(c) == nullness)).map(PsiClass::getQualifiedName).toList();
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List list2 = (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat((List)this.getNullables(), this.filterNickNames(Nullness.NULLABLE)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManagerImpl", "getNullablesWithNickNames"));
        }
        return list2;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List list2 = (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat((List)this.getNotNulls(), this.filterNickNames(Nullness.NOT_NULL)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullableNotNullManagerImpl", "getNotNullsWithNickNames"));
        }
        return list2;
    }
}

