/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityAnnotationModifier
extends TypeAnnotationModifier {
    @Nullable
    public TypeAnnotationProvider boundAppeared(@NotNull PsiType inferenceVariableType, @NotNull PsiType boundType) {
        PsiAnnotation[] annotations2;
        if (inferenceVariableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inferenceVariableType", "com/intellij/codeInsight/NullityAnnotationModifier", "boundAppeared"));
        }
        if (boundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundType", "com/intellij/codeInsight/NullityAnnotationModifier", "boundAppeared"));
        }
        for (PsiAnnotation annotation : annotations2 = inferenceVariableType.getAnnotations()) {
            if (!NullityAnnotationModifier.isMatchingNullityAnnotation(boundType, annotation)) continue;
            return NullityAnnotationModifier.removeAnnotation(annotations2, annotation);
        }
        return null;
    }

    private static boolean isMatchingNullityAnnotation(@NotNull PsiType boundType, PsiAnnotation annotation) {
        if (boundType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundType", "com/intellij/codeInsight/NullityAnnotationModifier", "isMatchingNullityAnnotation"));
        }
        String qName = annotation.getQualifiedName();
        return qName != null && (NullableNotNullManager.isNullableAnnotation((PsiAnnotation)annotation) || NullableNotNullManager.isNotNullAnnotation((PsiAnnotation)annotation)) && boundType.findAnnotation(qName) != null;
    }

    @Nullable
    public TypeAnnotationProvider modifyLowerBoundAnnotations(@NotNull PsiType lowerBound, @NotNull PsiType upperBound) {
        if (lowerBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerBound", "com/intellij/codeInsight/NullityAnnotationModifier", "modifyLowerBoundAnnotations"));
        }
        if (upperBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBound", "com/intellij/codeInsight/NullityAnnotationModifier", "modifyLowerBoundAnnotations"));
        }
        PsiAnnotation[] lowerAnnotations = lowerBound.getAnnotations();
        PsiAnnotation nullable = NullityAnnotationModifier.findNullable(lowerAnnotations);
        if (nullable != null && NullityAnnotationModifier.findNullable(upperBound.getAnnotations()) == null) {
            return NullityAnnotationModifier.removeAnnotation(lowerAnnotations, nullable);
        }
        return null;
    }

    private static PsiAnnotation findNullable(PsiAnnotation[] annotations2) {
        return (PsiAnnotation)ContainerUtil.find((Object[])annotations2, NullableNotNullManager::isNullableAnnotation);
    }

    @NotNull
    private static TypeAnnotationProvider removeAnnotation(PsiAnnotation[] annotations2, PsiAnnotation annotation) {
        ArrayList list2 = ContainerUtil.newArrayList((Object[])annotations2);
        list2.remove(annotation);
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create((PsiAnnotation[])list2.toArray(PsiAnnotation.EMPTY_ARRAY));
        if (typeAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/NullityAnnotationModifier", "removeAnnotation"));
        }
        return typeAnnotationProvider;
    }
}

