/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatChangedTextUtil {
    public static final Key<CharSequence> TEST_REVISION_CONTENT = Key.create((String)"test.revision.content");
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.FormatChangedTextUtil");

    protected FormatChangedTextUtil() {
    }

    @NotNull
    public static FormatChangedTextUtil getInstance() {
        FormatChangedTextUtil formatChangedTextUtil = (FormatChangedTextUtil)ServiceManager.getService(FormatChangedTextUtil.class);
        if (formatChangedTextUtil == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getInstance"));
        }
        return formatChangedTextUtil;
    }

    public static boolean hasChanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        Project project2 = file2.getProject();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project2).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        return FormatChangedTextUtil.hasChanges(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        Collection changes = ChangeListManager.getInstance((Project)project2).getChangesIn(file2);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull VirtualFile[] files, @NotNull Project project2) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        for (VirtualFile file2 : files) {
            if (!FormatChangedTextUtil.hasChanges(file2, project2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module2.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)new ReadAction<ModifiableModuleModel>(){

            protected void run(@NotNull Result<ModifiableModuleModel> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/actions/FormatChangedTextUtil$1", "run"));
                }
                result2.setResult((Object)ModuleManager.getInstance((Project)project2).getModifiableModel());
            }
        }.execute().getResultObject();
        try {
            for (Module module2 : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static List<PsiFile> getChangedFilesFromDirs(@NotNull Project project2, @NotNull List<PsiDirectory> dirs) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFilesFromDirs"));
        }
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFilesFromDirs"));
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        ArrayList changes = ContainerUtil.newArrayList();
        for (PsiDirectory dir : dirs) {
            changes.addAll(changeListManager.getChangesIn(dir.getVirtualFile()));
        }
        List<PsiFile> list2 = FormatChangedTextUtil.getChangedFiles(project2, changes);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFilesFromDirs"));
        }
        return list2;
    }

    @NotNull
    public static List<PsiFile> getChangedFiles(final @NotNull Project project2, @NotNull Collection<Change> changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFiles"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFiles"));
        }
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project2);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        List list2 = ContainerUtil.mapNotNull(changes, (Function)changeToPsiFileMapper);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFiles"));
        }
        return list2;
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project2, @NotNull PsiFile file2) throws FilesTooBigForDiffException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        return list2;
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedLinesNumber"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedLinesNumber"));
        }
        return -1;
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "isChangeNotTrackedForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "isChangeNotTrackedForFile"));
        }
        return false;
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) throws FilesTooBigForDiffException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedRangesInfo"));
        }
        return null;
    }
}

