/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class LastRunReformatCodeOptionsProvider {
    private static final String OPTIMIZE_IMPORTS_KEY = "LayoutCode.optimizeImports";
    private static final String REARRANGE_ENTRIES_KEY = "LayoutCode.rearrangeEntries";
    private static final String PROCESS_CHANGED_TEXT_KEY = "LayoutCode.processChangedText";
    private final PropertiesComponent myPropertiesComponent;

    public LastRunReformatCodeOptionsProvider(@NotNull PropertiesComponent propertiesComponent) {
        if (propertiesComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesComponent", "com/intellij/codeInsight/actions/LastRunReformatCodeOptionsProvider", "<init>"));
        }
        this.myPropertiesComponent = propertiesComponent;
    }

    public ReformatCodeRunOptions getLastRunOptions(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/LastRunReformatCodeOptionsProvider", "getLastRunOptions"));
        }
        Language language = file2.getLanguage();
        ReformatCodeRunOptions settings = new ReformatCodeRunOptions(this.getLastTextRangeType());
        settings.setOptimizeImports(this.getLastOptimizeImports());
        settings.setRearrangeCode(this.isRearrangeCode(language));
        return settings;
    }

    public void saveRearrangeState(@NotNull Language language, boolean value2) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/actions/LastRunReformatCodeOptionsProvider", "saveRearrangeState"));
        }
        String key2 = LastRunReformatCodeOptionsProvider.getRearrangeCodeKeyFor(language);
        this.myPropertiesComponent.setValue(key2, Boolean.toString(value2));
    }

    public void saveOptimizeImportsState(boolean value2) {
        String optimizeImports = Boolean.toString(value2);
        this.myPropertiesComponent.setValue(OPTIMIZE_IMPORTS_KEY, optimizeImports);
    }

    public boolean getLastOptimizeImports() {
        return this.myPropertiesComponent.getBoolean(OPTIMIZE_IMPORTS_KEY);
    }

    public TextRangeType getLastTextRangeType() {
        return this.myPropertiesComponent.getBoolean(PROCESS_CHANGED_TEXT_KEY) ? TextRangeType.VCS_CHANGED_TEXT : TextRangeType.WHOLE_FILE;
    }

    public void saveProcessVcsChangedTextState(boolean value2) {
        String processOnlyVcsChangedText = Boolean.toString(value2);
        this.myPropertiesComponent.setValue(PROCESS_CHANGED_TEXT_KEY, processOnlyVcsChangedText);
    }

    public void saveRearrangeCodeState(boolean value2) {
        this.myPropertiesComponent.setValue(REARRANGE_ENTRIES_KEY, value2);
    }

    public boolean getLastRearrangeCode() {
        return this.myPropertiesComponent.getBoolean(REARRANGE_ENTRIES_KEY);
    }

    public boolean isRearrangeCode(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/actions/LastRunReformatCodeOptionsProvider", "isRearrangeCode"));
        }
        String key2 = LastRunReformatCodeOptionsProvider.getRearrangeCodeKeyFor(language);
        return this.myPropertiesComponent.getBoolean(key2);
    }

    private static String getRearrangeCodeKeyFor(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/actions/LastRunReformatCodeOptionsProvider", "getRearrangeCodeKeyFor"));
        }
        return REARRANGE_ENTRIES_KEY + language.getDisplayName();
    }
}

