/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalExpressionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> CONSTRUCTOR_REF_INSERT_HANDLER = (context, item) -> {
        int start = context.getStartOffset();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)((PsiType)item.getObject()));
        if (psiClass != null) {
            String insertedName = StringUtil.trimEnd((String)item.getLookupString(), (String)"::new");
            while (insertedName.endsWith("[]")) {
                insertedName = insertedName.substring(0, insertedName.length() - 2);
            }
            JavaCompletionUtil.insertClassReference(psiClass, context.getFile(), start, start + insertedName.length());
        }
    };

    private static boolean isLambdaContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "isLambdaContext"));
        }
        PsiElement rulezzRef = element.getParent();
        return rulezzRef != null && rulezzRef instanceof PsiReferenceExpression && ((PsiReferenceExpression)rulezzRef).getQualifier() == null && LambdaUtil.isValidLambdaContext((PsiElement)rulezzRef.getParent());
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addCompletions"));
        }
        FunctionalExpressionCompletionProvider.addFunctionalVariants(parameters2, true, true, result2.getPrefixMatcher(), (Consumer<LookupElement>)result2);
    }

    static void addFunctionalVariants(@NotNull CompletionParameters parameters2, boolean smart, boolean addInheritors, PrefixMatcher matcher, Consumer<LookupElement> result2) {
        ExpectedTypeInfo[] expectedTypes;
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addFunctionalVariants"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters2.getOriginalFile()) || !FunctionalExpressionCompletionProvider.isLambdaContext(parameters2.getPosition())) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiType functionalInterfaceType;
            PsiMethod functionalInterfaceMethod;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            Object[] params = PsiParameter.EMPTY_ARRAY;
            PsiElement originalPosition = parameters2.getPosition();
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)functionalInterfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
            if (!functionalInterfaceMethod.hasTypeParameters()) {
                params = functionalInterfaceMethod.getParameterList().getParameters();
                Project project2 = functionalInterfaceMethod.getProject();
                JVMElementFactory jvmElementFactory = JVMElementFactories.getFactory((Language)originalPosition.getLanguage(), (Project)project2);
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
                if (jvmElementFactory != null) {
                    params = GenerateMembersUtil.overriddenParameters((PsiParameter[])params, jvmElementFactory, javaCodeStyleManager, substitutor, originalPosition);
                }
                String paramsString = params.length == 1 ? FunctionalExpressionCompletionProvider.getParamName(params[0], originalPosition) : "(" + StringUtil.join((Object[])params, parameter -> FunctionalExpressionCompletionProvider.getParamName(parameter, originalPosition), (String)",") + ")";
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(paramsString + " -> {}", null);
                lambdaExpression = (PsiLambdaExpression)codeStyleManager.reformat((PsiElement)lambdaExpression);
                paramsString = lambdaExpression.getParameterList().getText();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)functionalInterfaceMethod, (String)(paramsString + " -> ")).withPresentableText(paramsString + " -> {}").withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.Function);
                LookupElement lambdaElement = builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                result2.consume((Object)(smart ? lambdaElement : PrioritizedLookupElement.withPriority((LookupElement)lambdaElement, (double)1.0)));
            }
            FunctionalExpressionCompletionProvider.addMethodReferenceVariants(smart, addInheritors, parameters2, matcher, functionalInterfaceType, functionalInterfaceMethod, (PsiParameter[])params, originalPosition, substitutor, (Consumer<LookupElement>)((Consumer)element -> result2.consume((Object)(smart ? JavaSmartCompletionContributor.decorate(element, Arrays.asList(expectedTypes)) : element))));
        }
    }

    private static void addMethodReferenceVariants(boolean smart, boolean addInheritors, CompletionParameters parameters2, PrefixMatcher matcher, PsiType functionalInterfaceType, PsiMethod functionalInterfaceMethod, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, Consumer<LookupElement> result2) {
        PsiType expectedReturnType = substitutor.substitute(functionalInterfaceMethod.getReturnType());
        if (expectedReturnType == null) {
            return;
        }
        if (params.length > 0) {
            for (LookupElement element : FunctionalExpressionCompletionProvider.collectVariantsByReceiver(!smart, functionalInterfaceType, params, originalPosition, substitutor, expectedReturnType)) {
                result2.consume((Object)element);
            }
        }
        for (LookupElement element : FunctionalExpressionCompletionProvider.collectThisVariants(functionalInterfaceType, params, originalPosition, substitutor, expectedReturnType)) {
            result2.consume((Object)element);
        }
        for (LookupElement element : FunctionalExpressionCompletionProvider.collectStaticVariants(functionalInterfaceType, params, originalPosition, substitutor, expectedReturnType)) {
            result2.consume((Object)element);
        }
        Consumer consumer = eachReturnType -> {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)eachReturnType);
            if (psiClass == null || !MethodReferenceResolver.canBeConstructed(psiClass)) {
                return;
            }
            if (eachReturnType.getArrayDimensions() == 0) {
                PsiMethod[] constructors;
                for (PsiMethod psiMethod : constructors = psiClass.getConstructors()) {
                    if (!FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, params, substitutor, 0)) continue;
                    result2.consume((Object)FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, eachReturnType));
                }
                if (constructors.length == 0 && params.length == 0) {
                    result2.consume((Object)FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, eachReturnType));
                }
            } else if (params.length == 1 && PsiType.INT.equals((Object)params[0].getType())) {
                result2.consume((Object)FunctionalExpressionCompletionProvider.createConstructorReferenceLookup(functionalInterfaceType, eachReturnType));
            }
        };
        if (addInheritors && expectedReturnType instanceof PsiClassType) {
            JavaInheritorsGetter.processInheritors(parameters2, Collections.singletonList((PsiClassType)expectedReturnType), matcher, (Consumer<PsiType>)consumer);
        } else {
            consumer.consume((Object)expectedReturnType);
        }
    }

    private static LookupElement createConstructorReferenceLookup(@NotNull PsiType functionalInterfaceType, @NotNull PsiType constructedType) {
        if (functionalInterfaceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionalInterfaceType", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "createConstructorReferenceLookup"));
        }
        if (constructedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructedType", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "createConstructorReferenceLookup"));
        }
        constructedType = TypeConversionUtil.erasure((PsiType)constructedType);
        return LookupElementBuilder.create((Object)constructedType, (String)(constructedType.getPresentableText() + "::new")).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withInsertHandler(CONSTRUCTOR_REF_INSERT_HANDLER).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
    }

    @NotNull
    private static LookupElement createMethodRefOnThis(PsiType functionalInterfaceType, PsiMethod psiMethod, @Nullable PsiClass outerClass) {
        String fullString = (outerClass == null ? "" : outerClass.getName() + ".") + "this::" + psiMethod.getName();
        LookupElement lookupElement = LookupElementBuilder.create((Object)psiMethod, (String)fullString).withLookupString(psiMethod.getName()).withPresentableText(fullString).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "createMethodRefOnThis"));
        }
        return lookupElement;
    }

    @NotNull
    private static LookupElement createMethodRefOnClass(PsiType functionalInterfaceType, PsiMethod psiMethod, PsiClass qualifierClass) {
        String presentableText = qualifierClass.getName() + "::" + psiMethod.getName();
        LookupElement lookupElement = LookupElementBuilder.create((PsiNamedElement)psiMethod).withLookupString(presentableText).withPresentableText(presentableText).withInsertHandler((context, item) -> {
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)"::");
            JavaCompletionUtil.insertClassReference(qualifierClass, context.getFile(), context.getStartOffset());
        }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "createMethodRefOnClass"));
        }
        return lookupElement;
    }

    private static List<LookupElement> collectThisVariants(PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        JBIterable instanceClasses = JBIterable.generate((Object)originalPosition, PsiElement::getParent).filter(PsiMember.class).takeWhile(m -> !m.hasModifierProperty("static")).filter(PsiClass.class);
        boolean first = true;
        for (PsiClass psiClass : instanceClasses) {
            if (!first && psiClass.getName() == null) continue;
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (psiMethod.hasModifierProperty("static") || !FunctionalExpressionCompletionProvider.hasAppropriateReturnType(expectedReturnType, psiMethod) || !FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, params, substitutor, 0)) continue;
                result2.add(FunctionalExpressionCompletionProvider.createMethodRefOnThis(functionalInterfaceType, psiMethod, first ? null : psiClass));
            }
            first = false;
        }
        return result2;
    }

    private static List<LookupElement> collectStaticVariants(PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        for (PsiClass psiClass : JBIterable.generate((Object)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PsiClass.class), PsiClass::getContainingClass)) {
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (!psiMethod.hasModifierProperty("static") || !FunctionalExpressionCompletionProvider.hasAppropriateReturnType(expectedReturnType, psiMethod) || !FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, params, substitutor, 0)) continue;
                result2.add(FunctionalExpressionCompletionProvider.createMethodRefOnClass(functionalInterfaceType, psiMethod, psiClass));
            }
        }
        return result2;
    }

    private static List<LookupElement> collectVariantsByReceiver(boolean prioritize, PsiType functionalInterfaceType, PsiParameter[] params, PsiElement originalPosition, PsiSubstitutor substitutor, PsiType expectedReturnType) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        PsiType functionalInterfaceParamType = substitutor.substitute(params[0].getType());
        PsiClass paramClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)functionalInterfaceParamType);
        if (paramClass != null && !paramClass.hasTypeParameters()) {
            HashSet<String> visited = new HashSet<String>();
            for (PsiMethod psiMethod : paramClass.getAllMethods()) {
                PsiClass qualifierClass;
                PsiClass containingClass = psiMethod.getContainingClass();
                PsiClass psiClass = qualifierClass = containingClass != null ? containingClass : paramClass;
                if (!visited.add(psiMethod.getName()) || psiMethod.hasModifierProperty("static") || !FunctionalExpressionCompletionProvider.hasAppropriateReturnType(expectedReturnType, psiMethod) || !FunctionalExpressionCompletionProvider.areParameterTypesAppropriate(psiMethod, params, substitutor, 1) || !JavaResolveUtil.isAccessible((PsiMember)psiMethod, null, psiMethod.getModifierList(), originalPosition, null, null)) continue;
                LookupElement methodRefLookupElement = FunctionalExpressionCompletionProvider.createMethodRefOnClass(functionalInterfaceType, psiMethod, qualifierClass);
                if (prioritize && containingClass == paramClass) {
                    methodRefLookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)methodRefLookupElement, (int)1);
                }
                result2.add(methodRefLookupElement);
            }
        }
        return result2;
    }

    private static boolean hasAppropriateReturnType(PsiType expectedReturnType, PsiMethod psiMethod) {
        PsiType returnType = psiMethod.getReturnType();
        return returnType != null && TypeConversionUtil.isAssignable((PsiType)expectedReturnType, (PsiType)returnType);
    }

    private static boolean areParameterTypesAppropriate(PsiMethod psiMethod, PsiParameter[] params, PsiSubstitutor substitutor, int offset) {
        PsiParameterList parameterList = psiMethod.getParameterList();
        if (parameterList.getParametersCount() == params.length - offset) {
            PsiParameter[] referenceMethodParams = parameterList.getParameters();
            for (int i2 = 0; i2 < params.length - offset; ++i2) {
                if (Comparing.equal((Object)referenceMethodParams[i2].getType(), (Object)substitutor.substitute(params[i2 + offset].getType()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getParamName(PsiParameter param, PsiElement originalPosition) {
        return JavaCodeStyleManager.getInstance((Project)originalPosition.getProject()).suggestUniqueVariableName((String)ObjectUtils.assertNotNull((Object)param.getName()), originalPosition, false);
    }
}

