/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSession {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private Set<String> myKeywords = new HashSet<String>();
    private final MultiMap<CompletionResultSet, LookupElement> myBatchItems = MultiMap.create();
    private final CompletionResultSet myResult;

    public JavaCompletionSession(CompletionResultSet result2) {
        this.myResult = result2;
    }

    void registerBatchItems(CompletionResultSet result2, Collection<LookupElement> elements) {
        this.myBatchItems.putValues((Object)result2, elements);
    }

    void flushBatchItems() {
        for (Map.Entry entry : this.myBatchItems.entrySet()) {
            ((CompletionResultSet)entry.getKey()).addAllElements((Iterable)entry.getValue());
        }
        this.myBatchItems.clear();
    }

    public void addClassItem(LookupElement lookupElement) {
        PsiClass psiClass = JavaCompletionSession.extractClass(lookupElement);
        if (psiClass != null) {
            this.registerClass(psiClass);
        }
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    @NotNull
    PrefixMatcher getMatcher() {
        PrefixMatcher prefixMatcher = this.myResult.getPrefixMatcher();
        if (prefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSession", "getMatcher"));
        }
        return prefixMatcher;
    }

    @Nullable
    private static PsiClass extractClass(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            return (PsiClass)object;
        }
        if (object instanceof PsiMethod && ((PsiMethod)object).isConstructor()) {
            return ((PsiMethod)object).getContainingClass();
        }
        return null;
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaCompletionSession", "registerClass"));
        }
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)JavaCompletionSession.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaCompletionSession", "getClassName"));
        }
        String name2 = psiClass.getQualifiedName();
        return name2 == null ? psiClass.getName() : name2;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSession", "alreadyProcessed"));
        }
        PsiClass psiClass = JavaCompletionSession.extractClass(element);
        return psiClass != null && this.alreadyProcessed(psiClass);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/codeInsight/completion/JavaCompletionSession", "alreadyProcessed"));
        }
        String name2 = JavaCompletionSession.getClassName(object);
        return name2 == null || this.myAddedClasses.contains(name2);
    }

    public boolean isKeywordAlreadyProcessed(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/completion/JavaCompletionSession", "isKeywordAlreadyProcessed"));
        }
        return this.myKeywords.contains(keyword);
    }

    void registerKeyword(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/completion/JavaCompletionSession", "registerKeyword"));
        }
        this.myKeywords.add(keyword);
    }
}

