/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HippieWordCompletionHandler
implements CodeInsightActionHandler {
    private static final Key<CompletionState> KEY_STATE = new Key("HIPPIE_COMPLETION_STATE");
    private final boolean myForward;

    public HippieWordCompletionHandler(boolean forward) {
        this.myForward = forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "invoke"));
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (editor.isViewer() || editor.getDocument().getRangeGuard(caretOffset, caretOffset) != null) {
            editor.getDocument().fireReadOnlyModificationAttempt();
            EditorModificationUtil.checkModificationAllowed((Editor)editor);
            return;
        }
        LookupManager.getInstance(project2).hideActiveLookup();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        CompletionData data = HippieWordCompletionHandler.computeData(editor, charsSequence);
        CompletionState completionState = HippieWordCompletionHandler.getCompletionState(editor);
        String oldPrefix = completionState.oldPrefix;
        CompletionVariant lastProposedVariant = completionState.lastProposedVariant;
        boolean fromOtherFiles = completionState.fromOtherFiles;
        if (lastProposedVariant == null || oldPrefix == null || !completionState.caretOffsets.equals(HippieWordCompletionHandler.getCaretOffsets(editor)) || completionState.lastModCount != editor.getDocument().getModificationStamp()) {
            completionState.oldPrefix = oldPrefix = data.myPrefix;
            lastProposedVariant = null;
            fromOtherFiles = false;
        } else {
            data.startOffset = completionState.lastStartOffset;
        }
        CompletionVariant nextVariant = this.computeNextVariant(editor, oldPrefix, lastProposedVariant, data, file2, fromOtherFiles, false);
        if (nextVariant == null) {
            return;
        }
        RangeMarker start = editor.getDocument().createRangeMarker(data.startOffset, data.startOffset);
        nextVariant.fastenBelts();
        try {
            HippieWordCompletionHandler.insertStringForEachCaret(editor, nextVariant.variant, caretOffset - data.startOffset);
        }
        finally {
            nextVariant.unfastenBelts();
        }
        if (!start.isValid()) {
            editor.putUserData(KEY_STATE, null);
            return;
        }
        completionState.lastProposedVariant = nextVariant;
        completionState.lastStartOffset = start.getStartOffset();
        completionState.lastModCount = editor.getDocument().getModificationStamp();
        completionState.caretOffsets = HippieWordCompletionHandler.getCaretOffsets(editor);
        boolean bl = completionState.fromOtherFiles = nextVariant.editor != editor;
        if (nextVariant.editor == editor) {
            HippieWordCompletionHandler.highlightWord(nextVariant, project2);
        }
        start.dispose();
    }

    private static void insertStringForEachCaret(final Editor editor, final String text2, final int relativeOffset) {
        editor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                int caretOffset = caret.getOffset();
                int startOffset = Math.max(0, caretOffset - relativeOffset);
                editor.getDocument().replaceString(startOffset, caretOffset, (CharSequence)text2);
                caret.moveToOffset(startOffset + text2.length());
            }
        });
    }

    private static void highlightWord(CompletionVariant variant, Project project2) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlight(variant.editor, variant.offset, variant.offset + variant.variant.length(), attributes, 2, null, null);
    }

    @Nullable
    private CompletionVariant computeNextVariant(Editor editor, @Nullable String prefix, @Nullable CompletionVariant lastProposedVariant, CompletionData data, PsiFile file2, boolean includeWordsFromOtherFiles, boolean weAlreadyDoBestAttempt) {
        List<CompletionVariant> variants = HippieWordCompletionHandler.computeVariants(editor, new CamelHumpMatcher(StringUtil.notNullize((String)prefix)), file2, includeWordsFromOtherFiles);
        if (variants.isEmpty()) {
            return weAlreadyDoBestAttempt ? null : this.computeNextVariant(editor, prefix, null, data, file2, !includeWordsFromOtherFiles, true);
        }
        if (lastProposedVariant != null) {
            for (CompletionVariant completionVariant : variants) {
                if (!completionVariant.variant.equals(((CompletionVariant)lastProposedVariant).variant)) continue;
                if (((CompletionVariant)lastProposedVariant).offset > data.startOffset && completionVariant.offset > data.startOffset) {
                    lastProposedVariant = completionVariant;
                }
                if (((CompletionVariant)lastProposedVariant).offset < data.startOffset && completionVariant.offset < data.startOffset) {
                    lastProposedVariant = completionVariant;
                }
                if (!includeWordsFromOtherFiles || ((CompletionVariant)lastProposedVariant).editor != completionVariant.editor) continue;
                lastProposedVariant = completionVariant;
            }
        }
        if (lastProposedVariant == null) {
            CompletionVariant result2 = null;
            if (this.myForward) {
                if (includeWordsFromOtherFiles) {
                    return variants.get(variants.size() - 1);
                }
                for (CompletionVariant variant : variants) {
                    if (variant.offset < data.startOffset) {
                        result2 = variant;
                        continue;
                    }
                    if (result2 != null) continue;
                    result2 = variant;
                    break;
                }
            } else {
                if (includeWordsFromOtherFiles) {
                    return variants.get(0);
                }
                for (CompletionVariant variant : variants) {
                    if (variant.offset <= data.startOffset) continue;
                    return variant;
                }
                return variants.iterator().next();
            }
            return result2;
        }
        if (this.myForward) {
            CompletionVariant result2 = null;
            for (CompletionVariant variant : variants) {
                if (variant == lastProposedVariant) {
                    if (result2 == null) {
                        return this.computeNextVariant(editor, prefix, null, data, file2, !includeWordsFromOtherFiles, true);
                    }
                    return result2;
                }
                result2 = variant;
            }
            return variants.get(variants.size() - 1);
        }
        Iterator<CompletionVariant> i2 = variants.iterator();
        while (i2.hasNext()) {
            CompletionVariant completionVariant = i2.next();
            if (completionVariant != lastProposedVariant) continue;
            if (i2.hasNext()) {
                return i2.next();
            }
            return this.computeNextVariant(editor, prefix, null, data, file2, !includeWordsFromOtherFiles, true);
        }
        return null;
    }

    private static boolean containsLettersOrDigits(CharSequence seq, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (!Character.isLetterOrDigit(seq.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static List<CompletionVariant> computeVariants(@NotNull Editor editor, CamelHumpMatcher matcher, PsiFile file2, boolean includeWordsFromOtherFiles) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "computeVariants"));
        }
        ArrayList<CompletionVariant> words = new ArrayList<CompletionVariant>();
        ArrayList<CompletionVariant> afterWords = new ArrayList<CompletionVariant>();
        if (includeWordsFromOtherFiles) {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)file2.getProject()).getAllEditors()) {
                Editor anotherEditor;
                if (!(fileEditor instanceof TextEditor) || (anotherEditor = ((TextEditor)fileEditor).getEditor()) == editor) continue;
                HippieWordCompletionHandler.addWordsForEditor((EditorEx)anotherEditor, matcher, words, afterWords, false);
            }
        } else {
            HippieWordCompletionHandler.addWordsForEditor((EditorEx)editor, matcher, words, afterWords, true);
        }
        HashSet<String> allWords = new HashSet<String>();
        ArrayList<CompletionVariant> result2 = new ArrayList<CompletionVariant>();
        Collections.reverse(words);
        for (CompletionVariant variant : words) {
            if (allWords.contains(variant.variant)) continue;
            result2.add(variant);
            allWords.add(variant.variant);
        }
        Collections.reverse(result2);
        allWords.clear();
        for (CompletionVariant variant : afterWords) {
            if (allWords.contains(variant.variant)) continue;
            result2.add(variant);
            allWords.add(variant.variant);
        }
        return result2;
    }

    private static void addWordsForEditor(final EditorEx editor, final CamelHumpMatcher matcher, final List<CompletionVariant> words, final List<CompletionVariant> afterWords, boolean takeCaretsIntoAccount) {
        int[] caretOffsets;
        int primaryCaretOffset;
        final CharSequence chars = editor.getDocument().getImmutableCharSequence();
        if (takeCaretsIntoAccount) {
            CaretModel caretModel = editor.getCaretModel();
            primaryCaretOffset = caretModel.getOffset();
            caretOffsets = HippieWordCompletionHandler.getCaretOffsets(caretModel);
        } else {
            primaryCaretOffset = 0;
            caretOffsets = new int[1];
        }
        TokenProcessor processor2 = new TokenProcessor(){

            @Override
            public boolean processToken(int start, int end) {
                String word;
                for (int caretOffset : caretOffsets) {
                    if (start > caretOffset || end < caretOffset) continue;
                    return true;
                }
                if (end - start > matcher.getPrefix().length() && matcher.isStartMatch(word = chars.subSequence(start, end).toString())) {
                    CompletionVariant v = new CompletionVariant(editor, word, start);
                    if (end > primaryCaretOffset) {
                        afterWords.add(v);
                    } else {
                        words.add(v);
                    }
                }
                return true;
            }
        };
        HippieWordCompletionHandler.processWords(editor, 0, processor2);
    }

    private static int[] getCaretOffsets(CaretModel caretModel) {
        int[] caretOffsets = new int[caretModel.getCaretCount()];
        int i2 = 0;
        for (Caret caret : caretModel.getAllCarets()) {
            caretOffsets[i2++] = caret.getOffset();
        }
        return caretOffsets;
    }

    private static void processWords(Editor editor, int startOffset, TokenProcessor processor2) {
        CharSequence chars = editor.getDocument().getCharsSequence();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(startOffset);
        while (!iterator.atEnd()) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            while (start < end) {
                int wordEnd;
                int wordStart;
                for (wordStart = start; wordStart < end && !HippieWordCompletionHandler.isWordPart(chars.charAt(wordStart)); ++wordStart) {
                }
                for (wordEnd = wordStart; wordEnd < end && HippieWordCompletionHandler.isWordPart(chars.charAt(wordEnd)); ++wordEnd) {
                }
                if (wordEnd > wordStart && HippieWordCompletionHandler.containsLettersOrDigits(chars, wordStart, wordEnd) && !processor2.processToken(wordStart, wordEnd)) {
                    return;
                }
                start = wordEnd + 1;
            }
            iterator.advance();
        }
    }

    private static boolean isWordPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '*';
    }

    private static CompletionData computeData(Editor editor, final CharSequence charsSequence) {
        final int offset = editor.getCaretModel().getOffset();
        final CompletionData data = new CompletionData();
        HippieWordCompletionHandler.processWords(editor, Math.max(offset - 1, 0), new TokenProcessor(){

            @Override
            public boolean processToken(int start, int end) {
                if (start > offset) {
                    return false;
                }
                if (end >= offset) {
                    data.myPrefix = charsSequence.subSequence(start, offset).toString();
                    data.startOffset = start;
                    return false;
                }
                return true;
            }
        });
        if (data.myPrefix == null) {
            data.myPrefix = "";
            data.startOffset = offset;
        }
        return data;
    }

    private static CompletionState getCompletionState(Editor editor) {
        CompletionState state = (CompletionState)editor.getUserData(KEY_STATE);
        if (state == null) {
            state = new CompletionState();
            editor.putUserData(KEY_STATE, (Object)state);
        }
        return state;
    }

    @NotNull
    private static List<Integer> getCaretOffsets(Editor editor) {
        List list2 = ContainerUtil.map((Collection)editor.getCaretModel().getAllCarets(), caret -> caret.getOffset());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/actions/HippieWordCompletionHandler", "getCaretOffsets"));
        }
        return list2;
    }

    private static class CompletionState {
        public String oldPrefix;
        public CompletionVariant lastProposedVariant;
        public boolean fromOtherFiles;
        int lastStartOffset;
        long lastModCount;
        List<Integer> caretOffsets = Collections.emptyList();

        private CompletionState() {
        }
    }

    private static interface TokenProcessor {
        public boolean processToken(int var1, int var2);
    }

    public static class CompletionVariant {
        public final Editor editor;
        public final String variant;
        public int offset;
        private RangeMarker marker;

        public CompletionVariant(Editor editor, String variant, int offset) {
            this.editor = editor;
            this.variant = variant;
            this.offset = offset;
        }

        public void fastenBelts() {
            this.marker = this.editor.getDocument().createRangeMarker(this.offset, this.offset);
        }

        public void unfastenBelts() {
            if (this.marker.isValid()) {
                this.offset = this.marker.getStartOffset();
                this.marker.dispose();
            }
            this.marker = null;
        }
    }

    private static class CompletionData {
        public String myPrefix;
        public int startOffset;

        private CompletionData() {
        }
    }
}

