/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.CachedAnnotators;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultHighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    private final boolean highlightErrorElements;
    private final boolean runAnnotators;

    public DefaultHighlightVisitorBasedInspection(boolean highlightErrorElements, boolean runAnnotators) {
        this.highlightErrorElements = highlightErrorElements;
        this.runAnnotators = runAnnotators;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public void checkFile(@NotNull PsiFile originalFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "checkFile"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "checkFile"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "checkFile"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "checkFile"));
        }
        for (Pair<PsiFile, HighlightInfo> pair2 : DefaultHighlightVisitorBasedInspection.runGeneralHighlighting(originalFile, this.highlightErrorElements, this.runAnnotators, problemsHolder.isOnTheFly())) {
            PsiElement element;
            PsiFile file2 = (PsiFile)pair2.first;
            HighlightInfo info = (HighlightInfo)pair2.second;
            TextRange range = new TextRange(info.startOffset, info.endOffset);
            for (element = file2.findElementAt(info.startOffset); element != null && !element.getTextRange().contains(range); element = element.getParent()) {
            }
            if (element == null) {
                element = file2;
            }
            if (SuppressionUtil.inspectionResultSuppressed(element, (InspectionProfileEntry)this)) continue;
            GlobalInspectionUtil.createProblem(element, info, range.shiftRight(-element.getNode().getStartOffset()), info.getProblemGroup(), manager, problemDescriptionsProcessor, globalContext);
        }
    }

    public static List<Pair<PsiFile, HighlightInfo>> runGeneralHighlighting(PsiFile file2, boolean highlightErrorElements, boolean runAnnotators, boolean isOnTheFly) {
        MyPsiElementVisitor visitor = new MyPsiElementVisitor(highlightErrorElements, runAnnotators, isOnTheFly);
        file2.accept((PsiElementVisitor)visitor);
        return new ArrayList<Pair<PsiFile, HighlightInfo>>(visitor.result);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    private static class MyPsiElementVisitor
    extends PsiElementVisitor {
        private final boolean highlightErrorElements;
        private final boolean runAnnotators;
        private final List<Pair<PsiFile, HighlightInfo>> result = new ArrayList<Pair<PsiFile, HighlightInfo>>();

        public MyPsiElementVisitor(boolean highlightErrorElements, boolean runAnnotators, boolean isOnTheFly) {
            this.highlightErrorElements = highlightErrorElements;
            this.runAnnotators = runAnnotators;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitFile(PsiFile file2) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Project project2 = file2.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
            if (document == null) {
                return;
            }
            DaemonProgressIndicator progress = new DaemonProgressIndicator();
            progress.start();
            try {
                TextEditorHighlightingPassRegistrarEx passRegistrarEx = TextEditorHighlightingPassRegistrarEx.getInstanceEx(project2);
                List<TextEditorHighlightingPass> passes = passRegistrarEx.instantiateMainPasses(file2, document, HighlightInfoProcessor.getEmpty());
                List gpasses = ContainerUtil.collect(passes.iterator(), (FilteringIterator.InstanceOf)FilteringIterator.instanceOf(GeneralHighlightingPass.class));
                for (GeneralHighlightingPass gpass : gpasses) {
                    gpass.setHighlightVisitorProducer((NotNullProducer<HighlightVisitor[]>)((NotNullProducer)() -> {
                        gpass.incVisitorUsageCount(1);
                        DefaultHighlightVisitor visitor = new DefaultHighlightVisitor(project2, this.highlightErrorElements, this.runAnnotators, true, (CachedAnnotators)ServiceManager.getService((Project)project2, CachedAnnotators.class));
                        return new HighlightVisitor[]{visitor};
                    }));
                }
                for (TextEditorHighlightingPass pass : gpasses) {
                    pass.doCollectInformation(progress);
                    List<HighlightInfo> infos = pass.getInfos();
                    for (HighlightInfo info : infos) {
                        if (info == null || info.getSeverity().compareTo(HighlightSeverity.INFORMATION) <= 0) continue;
                        this.result.add((Pair<PsiFile, HighlightInfo>)Pair.create((Object)file2, (Object)info));
                    }
                }
            }
            finally {
                progress.stop();
            }
        }
    }

    public static class SyntaxErrorInspection
    extends DefaultHighlightVisitorBasedInspection {
        public SyntaxErrorInspection() {
            super(true, false);
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            if ("Syntax error" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$SyntaxErrorInspection", "getDisplayName"));
            }
            return "Syntax error";
        }

        @NotNull
        public String getShortName() {
            if ("SyntaxError" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$SyntaxErrorInspection", "getShortName"));
            }
            return "SyntaxError";
        }
    }

    public static class AnnotatorBasedInspection
    extends DefaultHighlightVisitorBasedInspection {
        private static final String ANNOTATOR_SHORT_NAME = "Annotator";

        public AnnotatorBasedInspection() {
            super(false, true);
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = this.getShortName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$AnnotatorBasedInspection", "getDisplayName"));
            }
            return string;
        }

        @NotNull
        public String getShortName() {
            if (ANNOTATOR_SHORT_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$AnnotatorBasedInspection", "getShortName"));
            }
            return ANNOTATOR_SHORT_NAME;
        }
    }
}

