/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final Key<Reference<DividedElements>> DIVIDED_ELEMENTS_KEY = Key.create((String)"DIVIDED_ELEMENTS");
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutsideAllRoots(@NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull Condition<PsiFile> rootFilter, @NotNull Processor<DividedElements> processor2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideAllRoots"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideAllRoots"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideAllRoots"));
        }
        if (rootFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFilter", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideAllRoots"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideAllRoots"));
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            if (!rootFilter.value((Object)root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, processor2);
        }
    }

    static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull Processor<DividedElements> processor2) {
        DividedElements elements;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        long modificationStamp = root.getModificationStamp();
        DividedElements cached = (DividedElements)SoftReference.dereference((Reference)((Reference)root.getUserData(DIVIDED_ELEMENTS_KEY)));
        if (cached == null || cached.modificationStamp != modificationStamp || !cached.restrictRange.equals((Object)restrictRange) || !cached.priorityRange.contains(priorityRange)) {
            elements = new DividedElements(modificationStamp, root, restrictRange, priorityRange);
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, elements.inside, elements.insideRanges, elements.outside, elements.outsideRanges, elements.parents, elements.parentRanges, true);
            root.putUserData(DIVIDED_ELEMENTS_KEY, new java.lang.ref.SoftReference<DividedElements>(elements));
        } else {
            elements = cached;
        }
        processor2.process((Object)elements);
    }

    private static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull List<PsiElement> inside, @NotNull List<ProperTextRange> insideRanges, @NotNull List<PsiElement> outside, @NotNull List<ProperTextRange> outsideRanges, @NotNull List<PsiElement> outParents, @NotNull List<ProperTextRange> outParentRanges, boolean includeParents) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (insideRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (outside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outside", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (outsideRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (outParents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outParents", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        if (outParentRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outParentRanges", "com/intellij/codeInsight/daemon/impl/Divider", "divideInsideAndOutsideInOneRoot"));
        }
        int startOffset = restrictRange.getStartOffset();
        int endOffset = restrictRange.getEndOffset();
        Condition[] filters = (Condition[])Extensions.getExtensions(CollectHighlightsUtil.EP_NAME);
        TIntStack starts = new TIntStack(10);
        starts.push(startOffset);
        Stack elements = new Stack(10);
        Stack children2 = new Stack(10);
        PsiFile element = root;
        PsiElement child = HAVE_TO_GET_CHILDREN;
        int offset = 0;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition filter : filters) {
                if (filter.value((Object)element)) continue;
                assert (child == HAVE_TO_GET_CHILDREN);
                child = null;
                break;
            }
            if (child == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                int start;
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (startOffset <= (start = starts.pop()) && offset <= endOffset) {
                    if (priorityRange.containsRange(start, offset)) {
                        inside.add((PsiElement)element);
                        insideRanges.add(new ProperTextRange(start, offset));
                    } else {
                        outside.add((PsiElement)element);
                        outsideRanges.add(new ProperTextRange(start, offset));
                    }
                }
                if (elements.isEmpty()) break;
                element = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset > endOffset) break;
            children2.push((Object)child.getNextSibling());
            starts.push(offset);
            elements.push((Object)element);
            element = child;
            child = HAVE_TO_GET_CHILDREN;
        }
        if (includeParents) {
            PsiElement parent;
            PsiElement psiElement = !outside.isEmpty() ? outside.get(outside.size() - 1) : (parent = !inside.isEmpty() ? inside.get(inside.size() - 1) : CollectHighlightsUtil.findCommonParent((PsiElement)root, startOffset, endOffset));
            while (parent != null && !(parent instanceof PsiFile)) {
                if ((parent = parent.getParent()) == null) continue;
                outParents.add(parent);
                TextRange textRange = parent.getTextRange();
                assert (textRange != null) : "Text range for " + parent + " is null. " + parent.getClass() + "; root: " + root + ": " + root.getVirtualFile();
                outParentRanges.add(ProperTextRange.create((Segment)textRange));
            }
        }
        assert (inside.size() == insideRanges.size());
        assert (outside.size() == outsideRanges.size());
        assert (outParents.size() == outParentRanges.size());
    }

    public static class DividedElements {
        private final long modificationStamp;
        @NotNull
        public final PsiFile root;
        @NotNull
        private final TextRange restrictRange;
        @NotNull
        private final TextRange priorityRange;
        public final List<PsiElement> inside;
        final List<ProperTextRange> insideRanges;
        public final List<PsiElement> outside;
        final List<ProperTextRange> outsideRanges;
        public final List<PsiElement> parents;
        final List<ProperTextRange> parentRanges;

        /*
         * WARNING - void declaration
         */
        private DividedElements(long modificationStamp, @NotNull PsiFile root, @NotNull TextRange restrictRange, @NotNull TextRange textRange) {
            void priorityRange;
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/daemon/impl/Divider$DividedElements", "<init>"));
            }
            if (restrictRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/Divider$DividedElements", "<init>"));
            }
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/Divider$DividedElements", "<init>"));
            }
            this.inside = new ArrayList<PsiElement>();
            this.insideRanges = new ArrayList<ProperTextRange>();
            this.outside = new ArrayList<PsiElement>();
            this.outsideRanges = new ArrayList<ProperTextRange>();
            this.parents = new ArrayList<PsiElement>();
            this.parentRanges = new ArrayList<ProperTextRange>();
            this.modificationStamp = modificationStamp;
            this.root = root;
            this.restrictRange = restrictRange;
            this.priorityRange = priorityRange;
        }
    }
}

