/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LineMarkersPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LineMarkersPass");
    private volatile List<LineMarkerInfo> myMarkers;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myPriorityBounds;
    @NotNull
    private final TextRange myRestrictRange;

    LineMarkersPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange priorityBounds, @NotNull TextRange restrictRange) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (priorityBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityBounds", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        super(project2, document, false);
        this.myMarkers = Collections.emptyList();
        this.myFile = file2;
        this.myPriorityBounds = priorityBounds;
        this.myRestrictRange = restrictRange;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = super.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getDocument"));
        }
        return document;
    }

    @Override
    public void doApplyInformationToEditor() {
        try {
            LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), (Segment)this.myRestrictRange, this.myMarkers, this.getId());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "doCollectInformation"));
        }
        ArrayList<LineMarkerInfo> lineMarkers = new ArrayList<LineMarkerInfo>();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myProject);
            if (!highlightingLevelManager.shouldHighlight((PsiElement)root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, this.myRestrictRange, this.myPriorityBounds, (Processor<Divider.DividedElements>)((Processor)elements -> {
                List<LineMarkerProvider> providers2 = LineMarkersPass.getMarkerProviders(language, this.myProject);
                ArrayList<LineMarkerProvider> providersList = new ArrayList<LineMarkerProvider>(providers2);
                LineMarkersPass.queryProviders(elements.inside, root, providersList, (PairConsumer<PsiElement, LineMarkerInfo>)((PairConsumer)(element, info) -> {
                    lineMarkers.add((LineMarkerInfo)info);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isValid()) {
                            LineMarkersUtil.addLineMarkerToEditorIncrementally(this.myProject, this.getDocument(), info);
                        }
                    }, this.myProject.getDisposed());
                }));
                LineMarkersPass.queryProviders(elements.outside, root, providersList, (PairConsumer<PsiElement, LineMarkerInfo>)((PairConsumer)(element, info) -> lineMarkers.add((LineMarkerInfo)info)));
                return true;
            }));
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers(lineMarkers, this.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersPass.doCollectInformation. lineMarkers: " + lineMarkers + "; merged: " + this.myMarkers);
        }
    }

    @NotNull
    private static List<LineMarkerInfo> mergeLineMarkers(@NotNull List<LineMarkerInfo> markers, @NotNull Document document) {
        if (markers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "mergeLineMarkers"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "mergeLineMarkers"));
        }
        ArrayList<MergeableLineMarkerInfo> forMerge = new ArrayList<MergeableLineMarkerInfo>();
        TIntObjectHashMap sameLineMarkers = new TIntObjectHashMap();
        for (int i = markers.size() - 1; i >= 0; --i) {
            LineMarkerInfo marker = markers.get(i);
            if (!(marker instanceof MergeableLineMarkerInfo)) continue;
            MergeableLineMarkerInfo mergeable = (MergeableLineMarkerInfo)marker;
            forMerge.add(mergeable);
            markers.remove(i);
            int line = document.getLineNumber(marker.startOffset);
            ArrayList<MergeableLineMarkerInfo> infos = (ArrayList<MergeableLineMarkerInfo>)sameLineMarkers.get(line);
            if (infos == null) {
                infos = new ArrayList<MergeableLineMarkerInfo>();
                sameLineMarkers.put(line, infos);
            }
            infos.add(mergeable);
        }
        if (forMerge.isEmpty()) {
            List<LineMarkerInfo> list2 = markers;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "mergeLineMarkers"));
            }
            return list2;
        }
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>(markers);
        for (Object v : sameLineMarkers.getValues()) {
            List infos = (List)v;
            result2.addAll(MergeableLineMarkerInfo.merge((List)infos));
        }
        ArrayList<LineMarkerInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "mergeLineMarkers"));
        }
        return arrayList;
    }

    @NotNull
    public static List<LineMarkerProvider> getMarkerProviders(@NotNull Language language, @NotNull Project project2) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getMarkerProviders"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getMarkerProviders"));
        }
        List forLanguage = LineMarkerProviders.INSTANCE.allForLanguageOrAny(language);
        List providers2 = DumbService.getInstance((Project)project2).filterByDumbAwareness((Collection)forLanguage);
        LineMarkerSettings settings = LineMarkerSettings.getSettings();
        List list2 = ContainerUtil.filter((Collection)providers2, provider -> !(provider instanceof LineMarkerProviderDescriptor) || settings.isEnabled((GutterIconDescriptor)((LineMarkerProviderDescriptor)provider)));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getMarkerProviders"));
        }
        return list2;
    }

    private static void queryProviders(@NotNull List<PsiElement> elements, @NotNull PsiFile containingFile, @NotNull List<LineMarkerProvider> providers2, @NotNull PairConsumer<PsiElement, LineMarkerInfo> consumer) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryProviders"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryProviders"));
        }
        if (providers2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryProviders"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryProviders"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        THashSet visitedInjectedFiles = new THashSet();
        for (int i = 0; i < elements.size(); ++i) {
            PsiElement element = elements.get(i);
            for (int j = 0; j < providers2.size(); ++j) {
                LineMarkerInfo info;
                ProgressManager.checkCanceled();
                LineMarkerProvider provider = providers2.get(j);
                try {
                    info = provider.getLineMarkerInfo(element);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (info == null) continue;
                consumer.consume((Object)element, (Object)info);
            }
            LineMarkersPass.queryLineMarkersForInjected(element, containingFile, (Set<PsiFile>)visitedInjectedFiles, consumer);
        }
        ArrayList slowLineMarkers = new ArrayList();
        for (int j = 0; j < providers2.size(); ++j) {
            ProgressManager.checkCanceled();
            LineMarkerProvider provider = providers2.get(j);
            try {
                provider.collectSlowLineMarkers(elements, slowLineMarkers);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (slowLineMarkers.isEmpty()) continue;
            for (int k = 0; k < slowLineMarkers.size(); ++k) {
                LineMarkerInfo slowInfo = (LineMarkerInfo)slowLineMarkers.get(k);
                PsiElement element = slowInfo.getElement();
                consumer.consume((Object)element, (Object)slowInfo);
            }
            slowLineMarkers.clear();
        }
    }

    private static void queryLineMarkersForInjected(@NotNull PsiElement element, @NotNull PsiFile containingFile, @NotNull Set<PsiFile> visitedInjectedFiles, @NotNull PairConsumer<PsiElement, LineMarkerInfo> consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkersForInjected"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkersForInjected"));
        }
        if (visitedInjectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedInjectedFiles", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkersForInjected"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkersForInjected"));
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        InjectedLanguageUtil.enumerate(element, containingFile, false, (injectedPsi, places) -> {
            if (visitedInjectedFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedInjectedFiles", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "lambda$queryLineMarkersForInjected$7"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "lambda$queryLineMarkersForInjected$7"));
            }
            if (!visitedInjectedFiles.add(injectedPsi)) {
                return;
            }
            Project project2 = injectedPsi.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project2).getCachedDocument(injectedPsi);
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            List<LineMarkerProvider> providers2 = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project2);
            LineMarkersPass.queryProviders(injElements, injectedPsi, providers2, (PairConsumer<PsiElement, LineMarkerInfo>)((PairConsumer)(injectedElement, injectedMarker) -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "lambda$null$6"));
                }
                GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                List editables = manager.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                for (TextRange editable : editables) {
                    TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, editable);
                    Icon icon = gutterRenderer == null ? null : gutterRenderer.getIcon();
                    GutterIconNavigationHandler navigationHandler = injectedMarker.getNavigationHandler();
                    LineMarkerInfo converted = new LineMarkerInfo(injectedElement, hostRange, icon, injectedMarker.updatePass, e -> injectedMarker.getLineMarkerTooltip(), navigationHandler, GutterIconRenderer.Alignment.RIGHT);
                    consumer.consume(injectedElement, (Object)converted);
                }
            }));
        });
    }

    @NotNull
    public static Collection<LineMarkerInfo> queryLineMarkers(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
        }
        if (file2.getNode() == null) {
            List<LineMarkerInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
            }
            return list2;
        }
        LineMarkersPass pass = new LineMarkersPass(file2.getProject(), file2, document, file2.getTextRange(), file2.getTextRange());
        pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        List<LineMarkerInfo> list3 = pass.myMarkers;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
        }
        return list3;
    }

    @NotNull
    public static LineMarkerInfo createMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFrom", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "createMethodSeparatorLineMarker"));
        }
        if (colorsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsManager", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "createMethodSeparatorLineMarker"));
        }
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme2 = colorsManager.getGlobalScheme();
        info.separatorColor = scheme2.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "createMethodSeparatorLineMarker"));
        }
        return lineMarkerInfo;
    }

    @Override
    public String toString() {
        return super.toString() + "; myBounds: " + this.myPriorityBounds;
    }
}

