/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.lang.LangBundle;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMessageUtil {
    private HighlightMessageUtil() {
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMessageUtil", "getSymbolName"));
        }
        return HighlightMessageUtil.getSymbolName(symbol, PsiSubstitutor.EMPTY);
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol, PsiSubstitutor substitutor) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMessageUtil", "getSymbolName"));
        }
        int options = 270338;
        return HighlightMessageUtil.getSymbolName(symbol, substitutor, options);
    }

    @Nullable
    public static String getSymbolName(@NotNull PsiElement symbol, PsiSubstitutor substitutor, int parameterOptions) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/daemon/impl/analysis/HighlightMessageUtil", "getSymbolName"));
        }
        String symbolName = null;
        if (symbol instanceof PsiClass) {
            if (symbol instanceof PsiAnonymousClass) {
                symbolName = LangBundle.message("java.terms.anonymous.class", new Object[0]);
            } else {
                symbolName = ((PsiClass)symbol).getQualifiedName();
                if (symbolName == null) {
                    symbolName = ((PsiClass)symbol).getName();
                }
            }
        } else if (symbol instanceof PsiMethod) {
            int options = 257;
            symbolName = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)symbol), (PsiSubstitutor)substitutor, (int)options, (int)parameterOptions);
        } else if (symbol instanceof PsiVariable) {
            symbolName = ((PsiVariable)symbol).getName();
        } else if (symbol instanceof PsiPackage) {
            symbolName = ((PsiPackage)symbol).getQualifiedName();
        } else if (symbol instanceof PsiFile) {
            PsiDirectory directory = ((PsiFile)symbol).getContainingDirectory();
            PsiPackage aPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
            symbolName = aPackage == null ? null : aPackage.getQualifiedName();
        } else if (symbol instanceof PsiDirectory) {
            symbolName = ((PsiDirectory)symbol).getName();
        } else if (symbol instanceof PsiJavaModule) {
            symbolName = ((PsiJavaModule)symbol).getName();
        }
        return symbolName;
    }
}

