/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddConstructorFix
implements LocalQuickFix,
IntentionAction {
    private final SmartPsiElementPointer<PsiClass> myBeanClass;
    private final List<PsiParameter> myParameters;
    private final String name;

    public AddConstructorFix(PsiClass beanClass, List<PsiParameter> parameters2) {
        this.myBeanClass = SmartPointerManager.getInstance((Project)beanClass.getProject()).createSmartPsiElementPointer((PsiElement)beanClass);
        this.myParameters = parameters2;
        String params = this.myParameters.stream().map(p -> p.getText()).collect(Collectors.joining(", "));
        String signature = beanClass.getName() + "(" + params + ")";
        this.name = QuickFixBundle.message("model.create.constructor.quickfix.message", signature);
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("model.create.constructor.quickfix.message.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "invoke"));
        }
        this.applyFix();
    }

    private void applyFix() {
        try {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myBeanClass.getContainingFile())) {
                return;
            }
            PsiClass psiClass = (PsiClass)this.myBeanClass.getElement();
            if (psiClass == null) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myBeanClass.getProject()).getElementFactory();
            PsiMethod constructor = elementFactory.createConstructor();
            for (PsiParameter parameter : this.myParameters) {
                constructor.getParameterList().add((PsiElement)parameter);
            }
            psiClass.add((PsiElement)constructor);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/quickfix/AddConstructorFix", "applyFix"));
        }
        this.applyFix();
    }
}

