/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class AddMissingRequiredAnnotationParametersFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(AddMissingRequiredAnnotationParametersFix.class);
    private final PsiAnnotation myAnnotation;
    private final PsiMethod[] myAnnotationMethods;
    private final Collection<String> myMissedElements;

    public AddMissingRequiredAnnotationParametersFix(PsiAnnotation annotation, PsiMethod[] annotationMethods, Collection<String> missedElements) {
        if (missedElements.isEmpty()) {
            throw new IllegalArgumentException("missedElements can't be empty");
        }
        this.myAnnotation = annotation;
        this.myAnnotationMethods = annotationMethods;
        this.myMissedElements = missedElements;
    }

    @NotNull
    public String getText() {
        String string = this.myMissedElements.size() == 1 ? QuickFixBundle.message("add.missing.annotation.single.parameter.fix", ContainerUtil.getFirstItem(this.myMissedElements)) : QuickFixBundle.message("add.missing.annotation.parameters.fix", StringUtil.join(this.myMissedElements, (String)", "));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("annotations.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "isAvailable"));
        }
        return this.myAnnotation.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "invoke"));
        }
        PsiNameValuePair[] addedParameters = this.myAnnotation.getParameterList().getAttributes();
        TObjectIntHashMap<String> annotationsOrderMap = this.getAnnotationsOrderMap();
        TreeSet<Pair> newParameters = new TreeSet<Pair>(Comparator.comparingInt(o -> annotationsOrderMap.get(o.getFirst())));
        boolean order = AddMissingRequiredAnnotationParametersFix.isAlreadyAddedOrdered(annotationsOrderMap, addedParameters);
        if (order && addedParameters.length != 0) {
            PsiAnnotationParameterList parameterList = this.myAnnotation.getParameterList();
            parameterList.deleteChildRange((PsiElement)addedParameters[0], (PsiElement)addedParameters[addedParameters.length - 1]);
            for (PsiNameValuePair addedParameter : addedParameters) {
                String name2 = addedParameter.getName();
                PsiAnnotationMemberValue value2 = addedParameter.getValue();
                if (name2 == null || value2 == null) {
                    LOG.error(String.format("Invalid annotation parameter name = %s, value = %s", name2, value2));
                    continue;
                }
                newParameters.add(Pair.create((Object)name2, (Object)value2));
            }
        }
        PsiExpression nullValue = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("null", null);
        for (String misssedParameter : this.myMissedElements) {
            newParameters.add(Pair.create((Object)misssedParameter, (Object)nullValue));
        }
        TemplateBuilderImpl builder = null;
        for (Pair newParameter : newParameters) {
            PsiAnnotationMemberValue value3 = this.myAnnotation.setDeclaredAttributeValue((String)newParameter.getFirst(), (PsiAnnotationMemberValue)newParameter.getSecond());
            if (!this.myMissedElements.contains(newParameter.getFirst())) continue;
            if (builder == null) {
                builder = new TemplateBuilderImpl((PsiElement)this.myAnnotation.getParameterList());
            }
            builder.replaceElement((PsiElement)value3, new EmptyExpression(), true);
        }
        editor.getCaretModel().moveToOffset(this.myAnnotation.getParameterList().getTextRange().getStartOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = documentManager.getDocument(file2);
        if (document == null) {
            throw new IllegalStateException();
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        TemplateManager.getInstance(project2).startTemplate(editor, builder.buildInlineTemplate(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private TObjectIntHashMap<String> getAnnotationsOrderMap() {
        TObjectIntHashMap map2 = new TObjectIntHashMap();
        for (int i2 = 0; i2 < this.myAnnotationMethods.length; ++i2) {
            map2.put((Object)this.myAnnotationMethods[i2].getName(), i2);
        }
        return map2;
    }

    private static boolean isAlreadyAddedOrdered(TObjectIntHashMap<String> orderMap, PsiNameValuePair[] addedParameters) {
        if (addedParameters.length <= 1) {
            return true;
        }
        int previousOrder = orderMap.get((Object)addedParameters[0].getName());
        for (int i2 = 1; i2 < addedParameters.length; ++i2) {
            int currentOrder = orderMap.get((Object)addedParameters[i2].getName());
            if (currentOrder < previousOrder) {
                return false;
            }
            previousOrder = currentOrder;
        }
        return true;
    }
}

