/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class AddRuntimeExceptionToThrowsAction
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.runtime.exception.to.throws.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddRuntimeExceptionToThrowsAction", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddRuntimeExceptionToThrowsAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiClassType aClass = AddRuntimeExceptionToThrowsAction.getRuntimeExceptionAtCaret(editor, file2);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2), PsiMethod.class);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project2, method, Collections.singleton(aClass));
    }

    private static boolean isMethodThrows(PsiMethod method, PsiClassType exception) {
        PsiClassType[] throwsTypes;
        for (PsiClassType throwsType : throwsTypes = method.getThrowsList().getReferencedTypes()) {
            if (!throwsType.isAssignableFrom((PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddRuntimeExceptionToThrowsAction", "isAvailable"));
        }
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiClassType exception = AddRuntimeExceptionToThrowsAction.getRuntimeExceptionAtCaret(editor, file2);
        if (exception == null) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2), PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
        if (method == null || !method.getThrowsList().isPhysical()) {
            return false;
        }
        return !AddRuntimeExceptionToThrowsAction.isMethodThrows(method, exception);
    }

    private static PsiClassType getRuntimeExceptionAtCaret(Editor editor, PsiFile file2) {
        PsiElement element = AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2);
        if (element == null) {
            return null;
        }
        PsiThrowStatement expression2 = (PsiThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiThrowStatement.class);
        if (expression2 == null) {
            return null;
        }
        PsiExpression exception = expression2.getException();
        if (exception == null) {
            return null;
        }
        PsiType type2 = exception.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        if (!ExceptionUtil.isUncheckedException((PsiClassType)type2)) {
            return null;
        }
        return (PsiClassType)type2;
    }

    private static PsiElement elementAtCaret(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        return file2.findElementAt(offset);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.runtime.exception.to.throws.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddRuntimeExceptionToThrowsAction", "getFamilyName"));
        }
        return string;
    }
}

