/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertDoubleToFloatFix
implements IntentionAction {
    private final PsiExpression myExpression;

    public ConvertDoubleToFloatFix(PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @NotNull
    public String getText() {
        String string = "Convert '" + this.myExpression.getText() + "' to float";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "isAvailable"));
        }
        if (this.myExpression.isValid() && !StringUtil.endsWithIgnoreCase((String)this.myExpression.getText(), (String)"f")) {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)this.createFloatingPointExpression(project2);
            Object value2 = expression2.getValue();
            return value2 instanceof Float && !((Float)value2).isInfinite() && (((Float)value2).floatValue() != 0.0f || TypeConversionUtil.isFPZero((String)expression2.getText()));
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "invoke"));
        }
        this.myExpression.replace((PsiElement)this.createFloatingPointExpression(project2));
    }

    private PsiExpression createFloatingPointExpression(Project project2) {
        String text2 = this.myExpression.getText();
        if (StringUtil.endsWithIgnoreCase((String)text2, (String)"d")) {
            return JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(text2.substring(0, text2.length() - 1) + "f", (PsiElement)this.myExpression);
        }
        return JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(text2 + "f", (PsiElement)this.myExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list2, @Nullable HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntentions"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntentions"));
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list2.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ConvertDoubleToFloatFix.registerIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list2);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions2, @Nullable HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        PsiParameter[] parameters2;
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntention"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntention"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertDoubleToFloatFix", "registerIntention"));
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && context.getManager().isInProject((PsiElement)method) && (parameters2 = method.getParameterList().getParameters()).length == expressions2.length) {
            int length = parameters2.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                PsiExpression expression2 = expressions2[i2];
                if (!(expression2 instanceof PsiLiteralExpression) || !PsiType.FLOAT.equals((Object)parameter.getType()) || !PsiType.DOUBLE.equals((Object)expression2.getType())) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new ConvertDoubleToFloatFix(expression2));
            }
        }
    }
}

