/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateEnumConstantFromUsageFix
extends CreateVarFromUsageFix
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix");

    public CreateEnumConstantFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected String getText(String varName) {
        return QuickFixBundle.message("create.enum.constant.from.usage.text", this.myReferenceExpression.getReferenceName());
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiMethod constructor;
        Object[] parameters2;
        LOG.assertTrue(targetClass.isEnum());
        String name2 = this.myReferenceExpression.getReferenceName();
        LOG.assertTrue(name2 != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myReferenceExpression.getProject()).getElementFactory();
        PsiEnumConstant enumConstant = elementFactory.createEnumConstantFromText(name2, null);
        enumConstant = (PsiEnumConstant)targetClass.add((PsiElement)enumConstant);
        PsiMethod[] constructors = targetClass.getConstructors();
        if (constructors.length > 0 && (parameters2 = (constructor = constructors[0]).getParameterList().getParameters()).length > 0) {
            String params = StringUtil.join((Object[])parameters2, psiParameter -> psiParameter.getName(), (String)",");
            enumConstant = (PsiEnumConstant)enumConstant.replace((PsiElement)elementFactory.createEnumConstantFromText(name2 + "(" + params + ")", null));
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)enumConstant);
            PsiExpressionList argumentList = enumConstant.getArgumentList();
            LOG.assertTrue(argumentList != null);
            for (PsiExpression expression2 : argumentList.getExpressions()) {
                builder.replaceElement((PsiElement)expression2, (Expression)new EmptyExpression());
            }
            enumConstant = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(enumConstant);
            Template template = builder.buildTemplate();
            Project project2 = targetClass.getProject();
            Editor newEditor = CreateEnumConstantFromUsageFix.positionCursor(project2, targetClass.getContainingFile(), (PsiElement)enumConstant);
            if (newEditor != null) {
                TextRange range = enumConstant.getTextRange();
                newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                CreateEnumConstantFromUsageFix.startTemplate(newEditor, template, project2);
            }
        }
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> classes2 = super.getTargetClasses(element);
        PsiClass enumClass = null;
        for (PsiClass aClass : classes2) {
            if (!aClass.isEnum()) continue;
            if (enumClass == null) {
                enumClass = aClass;
                continue;
            }
            enumClass = null;
            break;
        }
        if (enumClass != null) {
            List<Object> list2 = Collections.singletonList(enumClass);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateEnumConstantFromUsageFix", "getTargetClasses"));
            }
            return list2;
        }
        if (this.myReferenceExpression.isQualified()) {
            PsiClass aClass = CreateEnumConstantFromUsageFix.getTargetClassByExpectedTypes(this.myReferenceExpression.getQualifierExpression());
            if (aClass != null) {
                List<PsiClass> list3 = Collections.singletonList(aClass);
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateEnumConstantFromUsageFix", "getTargetClasses"));
                }
                return list3;
            }
        } else {
            PsiImportList importList;
            PsiFile containingFile;
            PsiClass targetClass = CreateEnumConstantFromUsageFix.getTargetClassByExpectedTypes((PsiExpression)this.myReferenceExpression);
            if (targetClass != null && (containingFile = this.myReferenceExpression.getContainingFile()) instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
                for (PsiImportStaticStatement statement2 : importList.getImportStaticStatements()) {
                    if (!statement2.isOnDemand() || !targetClass.equals(statement2.resolveTargetClass())) continue;
                    List<PsiClass> list4 = Collections.singletonList(targetClass);
                    if (list4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateEnumConstantFromUsageFix", "getTargetClasses"));
                    }
                    return list4;
                }
            }
        }
        List<PsiClass> list5 = Collections.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateEnumConstantFromUsageFix", "getTargetClasses"));
        }
        return list5;
    }

    private static PsiClass getTargetClassByExpectedTypes(PsiExpression expression2) {
        ExpectedTypeInfo[] typeInfos;
        for (ExpectedTypeInfo typeInfo : typeInfos = CreateFromUsageUtils.guessExpectedTypes(expression2, false)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeInfo.getType());
            if (psiClass == null || !psiClass.isEnum()) continue;
            return psiClass;
        }
        return null;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        PsiElement element = this.getElement();
        List<PsiClass> classes2 = this.getTargetClasses(element);
        if (classes2.size() != 1 || !classes2.get(0).isEnum()) {
            return false;
        }
        ExpectedTypeInfo[] typeInfos = CreateFromUsageUtils.guessExpectedTypes((PsiExpression)this.myReferenceExpression, false);
        PsiClassType enumType = JavaPsiFacade.getInstance((Project)this.myReferenceExpression.getProject()).getElementFactory().createType(classes2.get(0));
        for (ExpectedTypeInfo typeInfo : typeInfos) {
            if (!ExpectedTypeUtil.matches((PsiType)enumType, typeInfo)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constant.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateEnumConstantFromUsageFix", "getFamilyName"));
        }
        return string;
    }
}

