/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.CreatePropertyFromUsageFix;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateGetterSetterPropertyFromUsageFix
extends CreatePropertyFromUsageFix {
    public CreateGetterSetterPropertyFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterSetterPropertyFromUsageFix", "<init>"));
        }
        super(methodCall);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        boolean available = super.isAvailableImpl(offset);
        if (available) {
            this.setText("Create property");
        }
        return available;
    }

    @Override
    protected boolean checkTargetClasses(List<PsiClass> classes2, String methodName) {
        String propertyName = PropertyUtil.getPropertyName((String)methodName);
        if (propertyName == null) {
            return false;
        }
        String getterName = PropertyUtil.suggestGetterName((String)propertyName, null);
        String setterName = PropertyUtil.suggestSetterName((String)propertyName);
        for (PsiClass aClass : classes2) {
            if (aClass.findMethodsByName(getterName, false).length <= 0 && aClass.findMethodsByName(setterName, false).length <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void beforeTemplateFinished(PsiClass aClass, PsiField field) {
        PsiMethod setterPrototype;
        PsiMethod getterPrototype = GenerateMembersUtil.generateSimpleGetterPrototype(field);
        if (aClass.findMethodsBySignature(getterPrototype, false).length == 0) {
            aClass.add((PsiElement)getterPrototype);
        }
        if (aClass.findMethodsBySignature(setterPrototype = GenerateMembersUtil.generateSimpleSetterPrototype(field), false).length == 0) {
            aClass.add((PsiElement)setterPrototype);
        }
        super.beforeTemplateFinished(aClass, field);
    }
}

