/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreatePropertyFromUsageFix
extends CreateFromUsageBaseFix
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreatePropertyFromUsageFix");
    @NonNls
    private static final String FIELD_VARIABLE = "FIELD_NAME_VARIABLE";
    @NonNls
    private static final String TYPE_VARIABLE = "FIELD_TYPE_VARIABLE";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String SET_PREFIX = "set";
    protected final PsiMethodCallExpression myMethodCall;

    public CreatePropertyFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix", "<init>"));
        }
        this.myMethodCall = methodCall;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.property.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected PsiElement getElement() {
        if (!this.myMethodCall.isValid() || !this.myMethodCall.getManager().isInProject((PsiElement)this.myMethodCall)) {
            return null;
        }
        return this.myMethodCall;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (CreateMethodFromUsageFix.hasErrorsInArgumentList(this.myMethodCall)) {
            return false;
        }
        PsiReferenceExpression ref = this.myMethodCall.getMethodExpression();
        String methodName = this.myMethodCall.getMethodExpression().getReferenceName();
        LOG.assertTrue(methodName != null);
        String propertyName = PropertyUtil.getPropertyName((String)methodName);
        if (propertyName == null || propertyName.isEmpty()) {
            return false;
        }
        String getterOrSetter = null;
        if (methodName.startsWith(GET_PREFIX) || methodName.startsWith(IS_PREFIX)) {
            if (this.myMethodCall.getArgumentList().getExpressions().length != 0) {
                return false;
            }
            getterOrSetter = QuickFixBundle.message("create.getter", new Object[0]);
        } else if (methodName.startsWith(SET_PREFIX)) {
            if (this.myMethodCall.getArgumentList().getExpressions().length != 1) {
                return false;
            }
            getterOrSetter = QuickFixBundle.message("create.setter", new Object[0]);
        } else {
            LOG.error("Internal error in create property intention");
        }
        List<PsiClass> classes2 = this.getTargetClasses((PsiElement)this.myMethodCall);
        if (classes2.isEmpty()) {
            return false;
        }
        if (!this.checkTargetClasses(classes2, methodName)) {
            return false;
        }
        for (PsiClass aClass : classes2) {
            if (aClass.isInterface()) continue;
            this.setText(getterOrSetter);
            return true;
        }
        return false;
    }

    protected boolean checkTargetClasses(List<PsiClass> classes2, String methodName) {
        return true;
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> all = super.getTargetClasses(element);
        if (all.isEmpty()) {
            List<PsiClass> list2 = all;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix", "getTargetClasses"));
            }
            return list2;
        }
        ArrayList<PsiClass> nonInterfaces = new ArrayList<PsiClass>();
        for (PsiClass aClass : all) {
            if (aClass.isInterface()) continue;
            nonInterfaces.add(aClass);
        }
        ArrayList<PsiClass> arrayList = nonInterfaces;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreatePropertyFromUsageFix", "getTargetClasses"));
        }
        return arrayList;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiTypeElement typeReference2;
        PsiExpression fieldReference;
        PsiCodeBlock body2;
        PsiMethod accessor;
        PsiPrimitiveType type2;
        PsiType[] expectedTypes;
        PsiManager manager = this.myMethodCall.getManager();
        final Project project2 = manager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        boolean isStatic = false;
        PsiExpression qualifierExpression2 = this.myMethodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 != null) {
            PsiReference reference = qualifierExpression2.getReference();
            if (reference != null) {
                isStatic = reference.resolve() instanceof PsiClass;
            }
        } else {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myMethodCall, PsiMethod.class);
            if (method != null) {
                isStatic = method.hasModifierProperty("static");
            }
        }
        String fieldName = CreatePropertyFromUsageFix.getVariableName(this.myMethodCall, isStatic);
        LOG.assertTrue(fieldName != null);
        String callText = this.myMethodCall.getMethodExpression().getReferenceName();
        LOG.assertTrue(callText != null, (Object)this.myMethodCall.getMethodExpression());
        PsiField field = targetClass.findFieldByName(fieldName, true);
        if (callText.startsWith(GET_PREFIX)) {
            PsiType[] psiTypeArray;
            if (field != null) {
                PsiType[] psiTypeArray2 = new PsiType[1];
                psiTypeArray = psiTypeArray2;
                psiTypeArray2[0] = field.getType();
            } else {
                psiTypeArray = CreateFromUsageUtils.guessType((PsiExpression)this.myMethodCall, false);
            }
            expectedTypes = psiTypeArray;
            type2 = expectedTypes[0];
        } else if (callText.startsWith(IS_PREFIX)) {
            type2 = PsiType.BOOLEAN;
            expectedTypes = new PsiType[]{type2};
        } else {
            type2 = RefactoringUtil.getTypeByExpression(this.myMethodCall.getArgumentList().getExpressions()[0]);
            if (type2 == null || PsiType.NULL.equals((Object)type2)) {
                type2 = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)this.myMethodCall.getResolveScope());
            }
            expectedTypes = new PsiType[]{type2};
        }
        CreatePropertyFromUsageFix.positionCursor(project2, targetClass.getContainingFile(), (PsiElement)targetClass);
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        if (field == null) {
            field = factory.createField(fieldName, (PsiType)type2);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)isStatic);
        }
        if (callText.startsWith(GET_PREFIX) || callText.startsWith(IS_PREFIX)) {
            accessor = (PsiMethod)targetClass.add((PsiElement)GenerateMembersUtil.generateSimpleGetterPrototype(field));
            body2 = accessor.getBody();
            LOG.assertTrue(body2 != null, (Object)accessor.getText());
            fieldReference = ((PsiReturnStatement)body2.getStatements()[0]).getReturnValue();
            typeReference2 = accessor.getReturnTypeElement();
        } else {
            accessor = (PsiMethod)targetClass.add((PsiElement)GenerateMembersUtil.generateSimpleSetterPrototype(field, targetClass));
            body2 = accessor.getBody();
            LOG.assertTrue(body2 != null, (Object)accessor.getText());
            PsiAssignmentExpression expr = (PsiAssignmentExpression)((PsiExpressionStatement)body2.getStatements()[0]).getExpression();
            fieldReference = ((PsiReferenceExpression)expr.getLExpression()).getReferenceNameElement();
            typeReference2 = accessor.getParameterList().getParameters()[0].getTypeElement();
        }
        accessor.setName(callText);
        PsiUtil.setModifierProperty((PsiModifierListOwner)accessor, (String)"static", (boolean)isStatic);
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)accessor);
        builder.replaceElement((PsiElement)typeReference2, TYPE_VARIABLE, (Expression)new TypeExpression(project2, expectedTypes), true);
        builder.replaceElement((PsiElement)fieldReference, FIELD_VARIABLE, (Expression)new FieldExpression(field, targetClass, expectedTypes), true);
        builder.setEndVariableAfter((PsiElement)body2.getLBrace());
        accessor = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(accessor);
        LOG.assertTrue(accessor != null);
        targetClass = accessor.getContainingClass();
        LOG.assertTrue(targetClass != null);
        Template template = builder.buildTemplate();
        TextRange textRange = accessor.getTextRange();
        final PsiFile file2 = targetClass.getContainingFile();
        final Editor editor = CreatePropertyFromUsageFix.positionCursor(project2, targetClass.getContainingFile(), (PsiElement)accessor);
        if (editor == null) {
            return;
        }
        editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
        editor.getCaretModel().moveToOffset(textRange.getStartOffset());
        final boolean isStatic1 = isStatic;
        CreatePropertyFromUsageFix.startTemplate(editor, template, project2, new TemplateEditingAdapter(){

            @Override
            public void beforeTemplateFinished(TemplateState state, Template template) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    String fieldName1 = state.getVariableValue(CreatePropertyFromUsageFix.FIELD_VARIABLE).getText();
                    if (!PsiNameHelper.getInstance((Project)project2).isIdentifier(fieldName1)) {
                        return;
                    }
                    String fieldType = state.getVariableValue(CreatePropertyFromUsageFix.TYPE_VARIABLE).getText();
                    PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
                    PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                    if (aClass == null) {
                        return;
                    }
                    PsiField field1 = aClass.findFieldByName(fieldName1, true);
                    if (field1 != null) {
                        CreatePropertyFromUsageFix.this.beforeTemplateFinished(aClass, field1);
                        return;
                    }
                    PsiElementFactory factory1 = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                    try {
                        PsiType type1 = factory1.createTypeFromText(fieldType, (PsiElement)aClass);
                        try {
                            field1 = factory1.createField(fieldName1, type1);
                            field1 = (PsiField)aClass.add((PsiElement)field1);
                            PsiUtil.setModifierProperty((PsiModifierListOwner)field1, (String)"static", (boolean)isStatic1);
                            CreatePropertyFromUsageFix.this.beforeTemplateFinished(aClass, field1);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                });
            }

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                int offset = editor.getCaretModel().getOffset();
                PsiMethod generatedMethod = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiMethod.class, (boolean)false);
                if (generatedMethod != null) {
                    ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)generatedMethod));
                }
            }
        });
    }

    protected void beforeTemplateFinished(PsiClass aClass, PsiField field) {
        if (this.myMethodCall.isValid()) {
            CreatePropertyFromUsageFix.positionCursor(this.myMethodCall.getProject(), this.myMethodCall.getContainingFile(), (PsiElement)this.myMethodCall);
        }
    }

    private static String getVariableName(PsiMethodCallExpression methodCall, boolean isStatic) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)methodCall.getProject());
        String methodName = methodCall.getMethodExpression().getReferenceName();
        String propertyName = PropertyUtil.getPropertyName((String)methodName);
        if (propertyName != null && !propertyName.isEmpty()) {
            VariableKind kind2 = isStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
            return codeStyleManager.propertyNameToVariableName(propertyName, kind2);
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
        return methodCall.getMethodExpression().resolve() != null;
    }

    static class FieldExpression
    extends Expression {
        private final String myDefaultFieldName;
        private final PsiField myField;
        private final PsiClass myClass;
        private final List<SmartTypePointer> myExpectedTypes;

        public FieldExpression(PsiField field, PsiClass aClass, PsiType[] expectedTypes) {
            this.myField = field;
            this.myClass = aClass;
            this.myExpectedTypes = ContainerUtil.map((Object[])expectedTypes, type2 -> SmartTypePointerManager.getInstance((Project)field.getProject()).createSmartTypePointer(type2));
            this.myDefaultFieldName = field.getName();
        }

        public Result calculateResult(ExpressionContext context) {
            return new TextResult(this.myDefaultFieldName);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myDefaultFieldName);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            LinkedHashSet<LookupElementBuilder> set2 = new LinkedHashSet<LookupElementBuilder>();
            set2.add(JavaLookupElementBuilder.forField(this.myField).withTypeText(this.myField.getType().getPresentableText()));
            for (PsiField otherField : this.myClass.getFields()) {
                if (this.myDefaultFieldName.equals(otherField.getName())) continue;
                PsiType otherType = otherField.getType();
                for (SmartTypePointer pointer : this.myExpectedTypes) {
                    if (!otherType.equals(pointer.getType())) continue;
                    set2.add(JavaLookupElementBuilder.forField(otherField).withTypeText(otherType.getPresentableText()));
                }
            }
            if (set2.size() < 2) {
                return null;
            }
            return set2.toArray(new LookupElement[set2.size()]);
        }
    }
}

