/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeleteSideEffectsAwareFix
implements IntentionAction,
LowPriorityAction {
    private final SmartPsiElementPointer<PsiExpressionStatement> myPointer;
    private final String myMessage;

    public DeleteSideEffectsAwareFix(PsiExpressionStatement statement2) {
        PsiStatement[] statements;
        this.myPointer = SmartPointerManager.getInstance((Project)statement2.getProject()).createSmartPsiElementPointer((PsiElement)statement2);
        PsiExpression expression2 = statement2.getExpression();
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
        this.myMessage = sideEffects.isEmpty() ? QuickFixBundle.message("delete.element.fix.text", new Object[0]) : (sideEffects.size() == 1 && sideEffects.get(0) == PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2) ? "" : ((statements = StatementExtractor.generateStatements(sideEffects, expression2)).length == 1 && statements[0] instanceof PsiIfStatement ? QuickFixBundle.message("extract.side.effects.convert.to.if", new Object[0]) : QuickFixBundle.message("extract.side.effects", statements.length)));
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteSideEffectsAwareFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("extract.side.effects.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteSideEffectsAwareFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteSideEffectsAwareFix", "isAvailable"));
        }
        return !this.myMessage.isEmpty();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeleteSideEffectsAwareFix", "invoke"));
        }
        PsiExpressionStatement statement2 = (PsiExpressionStatement)this.myPointer.getElement();
        if (statement2 == null) {
            return;
        }
        PsiExpression expression2 = statement2.getExpression();
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression2);
        if (statements.length > 0) {
            BlockUtils.addBefore((PsiStatement)statement2, statements);
        }
        statement2.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

