/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializeFinalFieldInConstructorFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(InitializeFinalFieldInConstructorFix.class);
    private final PsiField myField;

    public InitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "<init>"));
        }
        this.myField = field;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("initialize.final.field.in.constructor.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "isAvailable"));
        }
        if (!this.myField.isValid() || this.myField.hasModifierProperty("static") || this.myField.hasInitializer()) {
            return false;
        }
        PsiClass containingClass = this.myField.getContainingClass();
        if (containingClass == null || containingClass.getName() == null) {
            return false;
        }
        PsiManager manager = this.myField.getManager();
        return manager != null && manager.isInProject((PsiElement)this.myField);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiClass myClass = this.myField.getContainingClass();
        if (myClass == null) {
            return;
        }
        if (myClass.getConstructors().length == 0) {
            InitializeFinalFieldInConstructorFix.createDefaultConstructor(myClass, project2, editor, file2);
        }
        List<PsiMethod> constructors = InitializeFinalFieldInConstructorFix.choose(InitializeFinalFieldInConstructorFix.filterIfFieldAlreadyAssigned(this.myField, myClass.getConstructors()), project2);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "lambda$invoke$0"));
            }
            InitializeFinalFieldInConstructorFix.addFieldInitialization(constructors, this.myField, project2, editor);
        });
    }

    private static void addFieldInitialization(@NotNull List<PsiMethod> constructors, @NotNull PsiField field, @NotNull Project project2, @Nullable Editor editor) {
        if (constructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructors", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (constructors.isEmpty()) {
            return;
        }
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer((PsiVariable)field);
        ArrayList<PsiExpression> rExpressions = new ArrayList<PsiExpression>(constructors.size());
        for (PsiMethod constructor : constructors) {
            rExpressions.add(InitializeFinalFieldInConstructorFix.addFieldInitialization(constructor, suggestedInitializers, field, project2));
        }
        AddVariableInitializerFix.runAssignmentTemplate(rExpressions, suggestedInitializers, editor);
    }

    @NotNull
    private static PsiExpression addFieldInitialization(@NotNull PsiMethod constructor, @NotNull LookupElement[] suggestedInitializers, @NotNull PsiField field, @NotNull Project project2) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (suggestedInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedInitializers", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        PsiCodeBlock methodBody2 = constructor.getBody();
        if (methodBody2 == null) {
            CreateFromUsageUtils.setupMethodBody(constructor);
            methodBody2 = constructor.getBody();
            LOG.assertTrue(methodBody2 != null);
        }
        String fieldName = field.getName();
        String stmtText = fieldName + " = " + suggestedInitializers[0].getPsiElement().getText() + ";";
        if (InitializeFinalFieldInConstructorFix.methodContainsParameterWithName(constructor, fieldName)) {
            stmtText = "this." + stmtText;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiExpressionStatement addedStatement = (PsiExpressionStatement)methodBody2.add(codeStyleManager.reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody2)));
        PsiExpression psiExpression = (PsiExpression)ObjectUtils.notNull((Object)((PsiAssignmentExpression)addedStatement.getExpression()).getRExpression());
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "addFieldInitialization"));
        }
        return psiExpression;
    }

    private static boolean methodContainsParameterWithName(@NotNull PsiMethod constructor, @NotNull String name2) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "methodContainsParameterWithName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "methodContainsParameterWithName"));
        }
        for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
            if (!name2.equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiMethod> choose(@NotNull PsiMethod[] ctors, @NotNull Project project2) {
        if (ctors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctors", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<PsiMethod> list2 = Arrays.asList(ctors);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
            }
            return list2;
        }
        if (ctors.length == 1) {
            List<PsiMethod> list3 = Arrays.asList(ctors[0]);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
            }
            return list3;
        }
        if (ctors.length > 1) {
            MemberChooser chooser = new MemberChooser((ClassMember[])InitializeFinalFieldInConstructorFix.toPsiMethodMemberArray(ctors), false, true, project2);
            chooser.setTitle(QuickFixBundle.message("initialize.final.field.in.constructor.choose.dialog.title", new Object[0]));
            chooser.show();
            List<PsiMethodMember> chosenMembers = chooser.getSelectedElements();
            if (chosenMembers != null) {
                List<PsiMethod> list4 = Arrays.asList(InitializeFinalFieldInConstructorFix.toPsiMethodArray(chosenMembers));
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
                }
                return list4;
            }
        }
        List<PsiMethod> list5 = Collections.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "choose"));
        }
        return list5;
    }

    @NotNull
    private static PsiMethodMember[] toPsiMethodMemberArray(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "toPsiMethodMemberArray"));
        }
        PsiMethodMember[] result2 = new PsiMethodMember[methods.length];
        for (int i2 = 0; i2 < methods.length; ++i2) {
            result2[i2] = new PsiMethodMember(methods[i2]);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "toPsiMethodMemberArray"));
        }
        return result2;
    }

    @NotNull
    private static PsiMethod[] toPsiMethodArray(@NotNull List<PsiMethodMember> methodMembers) {
        if (methodMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodMembers", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "toPsiMethodArray"));
        }
        PsiMethod[] result2 = new PsiMethod[methodMembers.size()];
        int i2 = 0;
        for (PsiMethodMember methodMember : methodMembers) {
            result2[i2++] = (PsiMethod)methodMember.getElement();
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "toPsiMethodArray"));
        }
        return result2;
    }

    private static void createDefaultConstructor(PsiClass psiClass, @NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "createDefaultConstructor"));
        }
        AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(psiClass);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "lambda$createDefaultConstructor$1"));
            }
            defaultConstructorFix.invoke(project2, editor, file2);
        });
    }

    @NotNull
    private static PsiMethod[] filterIfFieldAlreadyAssigned(@NotNull PsiField field, @NotNull PsiMethod[] ctors) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "filterIfFieldAlreadyAssigned"));
        }
        if (ctors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctors", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "filterIfFieldAlreadyAssigned"));
        }
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>(Arrays.asList(ctors));
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])ctors))) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) continue;
            result2.remove(PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class));
        }
        PsiMethod[] psiMethodArray = result2.toArray(new PsiMethod[result2.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InitializeFinalFieldInConstructorFix", "filterIfFieldAlreadyAssigned"));
        }
        return psiMethodArray;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

