/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodQuestionAction<T extends PsiMember>
implements QuestionAction {
    private static final Logger LOG = Logger.getInstance(StaticImportMethodQuestionAction.class);
    private final Project myProject;
    private final Editor myEditor;
    private List<T> myCandidates;
    private final SmartPsiElementPointer<? extends PsiElement> myRef;

    public StaticImportMethodQuestionAction(Project project2, Editor editor, List<T> candidates, SmartPsiElementPointer<? extends PsiElement> ref) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myCandidates = candidates;
        this.myRef = ref;
    }

    @NotNull
    protected String getPopupTitle() {
        String string = QuickFixBundle.message("method.to.import.chooser.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodQuestionAction", "getPopupTitle"));
        }
        return string;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiElement element = this.myRef.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        for (PsiMember targetMethod : this.myCandidates) {
            if (targetMethod.isValid()) continue;
            return false;
        }
        if (this.myCandidates.size() == 1) {
            this.doImport((PsiMember)this.myCandidates.get(0));
        } else {
            this.chooseAndImport(this.myEditor, this.myProject);
        }
        return true;
    }

    private void doImport(T toImport) {
        Project project2 = toImport.getProject();
        PsiElement element = this.myRef.getElement();
        if (element == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)QuickFixBundle.message("add.import", new Object[0]), null, () -> AddSingleMemberStaticImportAction.bindAllClassRefs(element.getContainingFile(), (PsiElement)toImport, toImport.getName(), toImport.getContainingClass()), (PsiFile[])new PsiFile[0]);
    }

    private void chooseAndImport(Editor editor, final Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doImport((PsiMember)this.myCandidates.get(0));
            return;
        }
        BaseListPopupStep step = new BaseListPopupStep<T>(this.getPopupTitle(), this.myCandidates){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(T selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    return this.doFinalStep(() -> {
                        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                        LOG.assertTrue(selectedValue.isValid());
                        StaticImportMethodQuestionAction.this.doImport(selectedValue);
                    });
                }
                return AddImportAction.getExcludesStep(PsiUtil.getMemberQualifiedName(selectedValue), project2);
            }

            public boolean hasSubstep(T selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(T value2) {
                String string = StaticImportMethodQuestionAction.this.getElementPresentableName(value2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodQuestionAction$1", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(T aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step){
            final PopupListElementRenderer rightArrow;
            {
                this.rightArrow = new PopupListElementRenderer(this);
            }

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new PsiElementListCellRenderer<T>(){

                    @Override
                    public String getElementText(T element) {
                        return StaticImportMethodQuestionAction.this.getElementPresentableName(element);
                    }

                    @Override
                    public String getContainerText(T element, String name2) {
                        return PsiClassListCellRenderer.getContainerTextStatic(element);
                    }

                    @Override
                    public int getIconFlags() {
                        return 0;
                    }

                    @Override
                    @Nullable
                    protected TextAttributes getNavigationItemAttributes(Object value2) {
                        PsiClass psiClass;
                        TextAttributes attrs = super.getNavigationItemAttributes(value2);
                        if (value2 instanceof PsiDocCommentOwner && !((PsiDocCommentOwner)value2).isDeprecated() && (psiClass = ((PsiMember)value2).getContainingClass()) != null && psiClass.isDeprecated()) {
                            return TextAttributes.merge((TextAttributes)attrs, (TextAttributes)super.getNavigationItemAttributes(psiClass));
                        }
                        return attrs;
                    }

                    @Override
                    protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
                        final DefaultListCellRenderer moduleRenderer = super.getRightCellRenderer(value2);
                        return new DefaultListCellRenderer(){

                            @Override
                            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                                JPanel panel2 = new JPanel(new BorderLayout());
                                if (moduleRenderer != null) {
                                    Component moduleComponent = moduleRenderer.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                                    if (!isSelected) {
                                        moduleComponent.setBackground(1.getBackgroundColor(value2));
                                    }
                                    panel2.add(moduleComponent, "Center");
                                }
                                rightArrow.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                                JLabel rightArrowComponent = rightArrow.getNextStepLabel();
                                panel2.add((Component)rightArrowComponent, "East");
                                return panel2;
                            }
                        };
                    }
                };
            }
        };
        popup.showInBestPositionFor(editor);
    }

    private String getElementPresentableName(T element) {
        PsiClass aClass = element.getContainingClass();
        LOG.assertTrue(aClass != null);
        return ClassPresentationUtil.getNameForClass(aClass, false) + "." + element.getName();
    }
}

