/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapStringWithFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    public static final MyMethodArgumentFixerFactory REGISTAR = new MyMethodArgumentFixerFactory();
    @Nullable
    private final PsiType myType;

    public WrapStringWithFileFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "<init>"));
        }
        super((PsiElement)expression2);
        this.myType = type2;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.with.java.io.file.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "isAvailable"));
        }
        return this.myType != null && this.myType.isValid() && this.myType.equalsToText("java.io.File") && startElement.isValid() && startElement.getManager().isInProject(startElement) && WrapStringWithFileFix.isStringType(startElement);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "invoke"));
        }
        startElement.replace(WrapStringWithFileFix.getModifiedExpression(startElement));
    }

    private static boolean isStringType(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "isStringType"));
        }
        if (!(expression2 instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)expression2).getType();
        if (type2 == null) {
            return false;
        }
        return type2.equalsToText("java.lang.String");
    }

    private static PsiElement getModifiedExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix", "getModifiedExpression"));
        }
        return JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText("new java.io.File(" + expression2.getText() + ")", expression2);
    }

    public static class MyMethodArgumentFixerFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return WrapStringWithFileFix.isStringType((PsiElement)expression2) && toType.equalsToText("java.io.File") ? (PsiExpression)WrapStringWithFileFix.getModifiedExpression((PsiElement)expression2) : null;
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFixerFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFixerFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFixerFactory", "areTypesConvertible"));
            }
            return parameterType.isConvertibleFrom(exprType) || parameterType.equalsToText("java.io.File") && exprType.equalsToText("java.lang.String");
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list2, int i2, PsiType toType) {
            return new MyMethodArgumentFix(list2, i2, toType, this);
        }
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix
    implements HighPriorityAction {
        protected MyMethodArgumentFix(@NotNull PsiExpressionList list2, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFix", "<init>"));
            }
            if (toType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFix", "<init>"));
            }
            if (fixerActionFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixerActionFactory", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFix", "<init>"));
            }
            super(list2, i2, toType, fixerActionFactory);
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.myArgList.getExpressions().length == 1 ? QuickFixBundle.message("wrap.with.java.io.file.parameter.single.text", new Object[0]) : QuickFixBundle.message("wrap.with.java.io.file.parameter.multiple.text", this.myIndex + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFix", "getText"));
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapStringWithFileFix$MyMethodArgumentFix", "isAvailable"));
            }
            return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2) && super.isAvailable(project2, editor, file2);
        }
    }
}

