/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodOverloadSwitchHandler
extends EditorWriteActionHandler {
    private static final Key<Map<String, String>> ENTERED_PARAMETERS = Key.create((String)"entered.parameters");
    private final boolean mySwitchUp;

    public JavaMethodOverloadSwitchHandler(boolean up) {
        this.mySwitchUp = up;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JavaMethodOverloadSwitchHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/editorActions/JavaMethodOverloadSwitchHandler", "isEnabledForCaret"));
        }
        if (!ParameterInfoController.areParametersHintsEnabledOnCompletion() || !ParameterInfoController.existsForEditor(editor)) {
            return false;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        PsiElement exprList = JavaMethodOverloadSwitchHandler.getExpressionList(editor, caret.getOffset(), project2);
        if (exprList == null) {
            return false;
        }
        int lbraceOffset = exprList.getTextRange().getStartOffset();
        return ParameterInfoController.findControllerAtOffset(editor, lbraceOffset) != null;
    }

    @Nullable
    private static PsiElement getExpressionList(@NotNull Editor editor, int offset, @NotNull Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JavaMethodOverloadSwitchHandler", "getExpressionList"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/JavaMethodOverloadSwitchHandler", "getExpressionList"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        return file2 != null ? (PsiElement)ParameterInfoController.findArgumentList(file2, offset, -1) : null;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        PsiExpression[] enteredExpressions;
        int enteredCount;
        Project project2;
        if (caret == null) {
            caret = editor.getCaretModel().getPrimaryCaret();
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement exprList = JavaMethodOverloadSwitchHandler.getExpressionList(editor, caret.getOffset(), project2);
        if (!(exprList instanceof PsiExpressionList) || !(exprList.getParent() instanceof PsiCall)) {
            return;
        }
        int lbraceOffset = exprList.getTextRange().getStartOffset();
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        if (controller == null) {
            return;
        }
        Object[] objects = controller.getObjects();
        Object highlighted = controller.getHighlighted();
        if (objects == null || objects.length <= 1 || highlighted == null) {
            return;
        }
        int currentIndex = ContainerUtil.indexOf(Arrays.asList(objects), (Object)highlighted);
        if (currentIndex < 0) {
            return;
        }
        PsiMethod currentMethod = (PsiMethod)((CandidateInfo)objects[currentIndex]).getElement();
        int currentMethodParameterCount = currentMethod.getParameterList().getParametersCount();
        if (currentMethodParameterCount != (enteredCount = (enteredExpressions = ((PsiExpressionList)exprList).getExpressions()).length) && (enteredCount != 0 || currentMethodParameterCount != 1)) {
            return;
        }
        HashMap<String, String> enteredParameters = (HashMap<String, String>)exprList.getUserData(ENTERED_PARAMETERS);
        if (enteredParameters == null) {
            enteredParameters = new HashMap<String, String>();
            exprList.putUserData(ENTERED_PARAMETERS, enteredParameters);
        }
        for (int i2 = 0; i2 < enteredExpressions.length; ++i2) {
            PsiExpression expression2 = enteredExpressions[i2];
            String value2 = expression2.getText().trim();
            if (value2.isEmpty()) continue;
            String key2 = JavaMethodOverloadSwitchHandler.getParameterKey(currentMethod, i2);
            enteredParameters.put(key2, value2);
        }
        PsiMethod targetMethod = (PsiMethod)((CandidateInfo)objects[(currentIndex + (this.mySwitchUp ? -1 : 1) + objects.length) % objects.length]).getElement();
        PsiParameterList parameterList = targetMethod.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        caret.moveToOffset(lbraceOffset);
        int offset = lbraceOffset + 1;
        int endOffset = exprList.getTextRange().getEndOffset() - 1;
        List oldInlays = editor.getInlayModel().getInlineElementsInRange(offset, endOffset);
        for (Inlay inlay : oldInlays) {
            Disposer.dispose((Disposable)inlay);
        }
        editor.getDocument().deleteString(offset, endOffset);
        int targetCaretPosition = -1;
        ArrayList<Inlay> addedHints = new ArrayList<Inlay>(parametersCount);
        for (int i3 = 0; i3 < parametersCount; ++i3) {
            String key3 = JavaMethodOverloadSwitchHandler.getParameterKey(targetMethod, i3);
            String value3 = enteredParameters.getOrDefault(key3, "");
            if (value3.isEmpty() && targetCaretPosition == -1) {
                targetCaretPosition = offset;
            }
            if (i3 < parametersCount - 1) {
                value3 = value3 + ", ";
            }
            editor.getDocument().insertString(offset, (CharSequence)value3);
            String name2 = parameterList.getParameters()[i3].getName();
            if (name2 != null) {
                addedHints.add(ParameterHintsPresentationManager.getInstance().addHint(editor, offset, name2 + ":", false, true));
            }
            offset += value3.length();
        }
        if (targetCaretPosition == -1) {
            targetCaretPosition = offset;
        }
        caret.moveToLogicalPosition(editor.offsetToLogicalPosition(targetCaretPosition).leanForward(true));
        exprList.putUserData(JavaMethodCallElement.COMPLETION_HINTS, addedHints);
        Disposer.register((Disposable)controller, () -> {
            for (Inlay hint : addedHints) {
                if (hint == null) continue;
                ParameterHintsPresentationManager.getInstance().unpin(hint);
            }
            addedHints.clear();
        });
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        CompletionMemory.registerChosenMethod(targetMethod, (PsiCall)exprList.getParent());
        controller.updateComponent();
    }

    private static String getParameterKey(PsiMethod method, int parameterIndex) {
        PsiParameter parameter = method.getParameterList().getParameters()[parameterIndex];
        return parameter.getName() + ":" + parameter.getType().getCanonicalText();
    }
}

