/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;

public class LiteralJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(Document doc, PsiFile psiFile, int offsetNear, int end) {
        CharSequence text2 = doc.getCharsSequence();
        int start = offsetNear;
        while (text2.charAt(start) == ' ' || text2.charAt(start) == '\t' || text2.charAt(start) == '+') {
            --start;
        }
        if (text2.charAt(start) == '\"') {
            --start;
        }
        if (start < offsetNear) {
            ++start;
        }
        int state = 0;
        int startQuoteOffset = -1;
        block6: for (int j = start; j < doc.getTextLength(); ++j) {
            switch (text2.charAt(j)) {
                case '\t': 
                case ' ': {
                    continue block6;
                }
                case '\"': {
                    if (state == 0) {
                        state = 1;
                        startQuoteOffset = j;
                        PsiElement psiAtOffset = psiFile.findElementAt(j);
                        if (!(psiAtOffset instanceof PsiJavaToken)) {
                            return -1;
                        }
                        if (((PsiJavaToken)psiAtOffset).getTokenType() == JavaTokenType.STRING_LITERAL) continue block6;
                        return -1;
                    }
                    if (state != 2) break block6;
                    doc.deleteString(startQuoteOffset, j + 1);
                    return startQuoteOffset;
                }
                case '+': {
                    if (state != 1) break block6;
                    state = 2;
                    continue block6;
                }
            }
        }
        return -1;
    }
}

