/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class ReferenceTransferableData
implements TextBlockTransferableData,
Cloneable,
Serializable {
    private final ReferenceData[] myReferenceDatas;

    public ReferenceTransferableData(@NotNull ReferenceData[] referenceDatas) {
        if (referenceDatas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceDatas", "com/intellij/codeInsight/editorActions/ReferenceTransferableData", "<init>"));
        }
        this.myReferenceDatas = referenceDatas;
    }

    @Override
    public DataFlavor getFlavor() {
        return ReferenceData.getDataFlavor();
    }

    @Override
    public int getOffsetCount() {
        return this.myReferenceDatas.length * 2;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        for (ReferenceData data : this.myReferenceDatas) {
            offsets[index++] = data.startOffset;
            offsets[index++] = data.endOffset;
        }
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        for (ReferenceData data : this.myReferenceDatas) {
            data.startOffset = offsets[index++];
            data.endOffset = offsets[index++];
        }
        return index;
    }

    public ReferenceTransferableData clone() {
        ReferenceData[] newReferenceData = new ReferenceData[this.myReferenceDatas.length];
        for (int i2 = 0; i2 < this.myReferenceDatas.length; ++i2) {
            newReferenceData[i2] = (ReferenceData)this.myReferenceDatas[i2].clone();
        }
        return new ReferenceTransferableData(newReferenceData);
    }

    @NotNull
    public ReferenceData[] getData() {
        if (this.myReferenceDatas == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/ReferenceTransferableData", "getData"));
        }
        return this.myReferenceDatas;
    }
}

