/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class RestoreReferencesDialog
extends DialogWrapper {
    private final Object[] myNamedElements;
    private JList myList;
    private Object[] mySelectedElements = PsiClass.EMPTY_ARRAY;
    private boolean myContainsClassesOnly = true;

    public RestoreReferencesDialog(Project project2, Object[] elements) {
        super(project2, true);
        this.myNamedElements = elements;
        for (Object element : elements) {
            if (element instanceof PsiClass) continue;
            this.myContainsClassesOnly = false;
            break;
        }
        if (this.myContainsClassesOnly) {
            this.setTitle(CodeInsightBundle.message((String)"dialog.import.on.paste.title", (Object[])new Object[0]));
        } else {
            this.setTitle(CodeInsightBundle.message((String)"dialog.import.on.paste.title2", (Object[])new Object[0]));
        }
        this.init();
        this.myList.setSelectionInterval(0, this.myNamedElements.length - 1);
    }

    protected void doOKAction() {
        Object[] values = this.myList.getSelectedValues();
        this.mySelectedElements = new Object[values.length];
        System.arraycopy(values, 0, this.mySelectedElements, 0, values.length);
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(10, 4));
        this.myList = new JBList(this.myNamedElements);
        this.myList.setCellRenderer(new FQNameCellRenderer());
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
        panel2.add((Component)new JBLabel(this.myContainsClassesOnly ? CodeInsightBundle.message((String)"dialog.paste.on.import.text", (Object[])new Object[0]) : CodeInsightBundle.message((String)"dialog.paste.on.import.text2", (Object[])new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), "North");
        JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JButton okButton = new JButton(CommonBundle.getOkButtonText());
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        buttonPanel.add(cancelButton);
        panel2.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.editorActions.RestoreReferencesDialog";
    }

    @NotNull
    public Object[] getSelectedElements() {
        if (this.mySelectedElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/RestoreReferencesDialog", "getSelectedElements"));
        }
        return this.mySelectedElements;
    }
}

