/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordUtil {
    private static ExtendWordSelectionHandler[] SELECTIONERS = new ExtendWordSelectionHandler[0];
    private static boolean ourExtensionsLoaded = false;
    public static final CharCondition JAVA_IDENTIFIER_PART_CONDITION = new CharCondition(){

        @Override
        public boolean value(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    };

    private SelectWordUtil() {
    }

    @Deprecated
    public static void registerSelectioner(ExtendWordSelectionHandler selectioner) {
        SELECTIONERS = (ExtendWordSelectionHandler[])ArrayUtil.append((Object[])SELECTIONERS, (Object)selectioner);
    }

    static ExtendWordSelectionHandler[] getExtendWordSelectionHandlers() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            for (ExtendWordSelectionHandler handler2 : (ExtendWordSelectionHandler[])Extensions.getExtensions((ExtensionPointName)ExtendWordSelectionHandler.EP_NAME)) {
                SelectWordUtil.registerSelectioner(handler2);
            }
        }
        return SELECTIONERS;
    }

    public static void addWordSelection(boolean camel, CharSequence editorText, int cursorOffset, @NotNull List<TextRange> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/editorActions/SelectWordUtil", "addWordSelection"));
        }
        SelectWordUtil.addWordSelection(camel, editorText, cursorOffset, ranges, JAVA_IDENTIFIER_PART_CONDITION);
    }

    public static void addWordOrLexemeSelection(boolean camel, @NotNull Editor editor, int cursorOffset, @NotNull List<TextRange> ranges) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordUtil", "addWordOrLexemeSelection"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/editorActions/SelectWordUtil", "addWordOrLexemeSelection"));
        }
        SelectWordUtil.addWordOrLexemeSelection(camel, editor, cursorOffset, ranges, JAVA_IDENTIFIER_PART_CONDITION);
    }

    public static void addWordSelection(boolean camel, CharSequence editorText, int cursorOffset, @NotNull List<TextRange> ranges, CharCondition isWordPartCondition) {
        TextRange range;
        TextRange camelRange;
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/editorActions/SelectWordUtil", "addWordSelection"));
        }
        TextRange textRange = camelRange = camel ? SelectWordUtil.getCamelSelectionRange(editorText, cursorOffset, isWordPartCondition) : null;
        if (camelRange != null) {
            ranges.add(camelRange);
        }
        if ((range = SelectWordUtil.getWordSelectionRange(editorText, cursorOffset, isWordPartCondition)) != null && !range.equals((Object)camelRange)) {
            ranges.add(range);
        }
    }

    public static void addWordOrLexemeSelection(boolean camel, @NotNull Editor editor, int cursorOffset, @NotNull List<TextRange> ranges, CharCondition isWordPartCondition) {
        TextRange range;
        TextRange camelRange;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordUtil", "addWordOrLexemeSelection"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/editorActions/SelectWordUtil", "addWordOrLexemeSelection"));
        }
        TextRange textRange = camelRange = camel ? SelectWordUtil.getCamelSelectionRange(editor.getDocument().getImmutableCharSequence(), cursorOffset, isWordPartCondition) : null;
        if (camelRange != null) {
            ranges.add(camelRange);
        }
        if ((range = SelectWordUtil.getWordOrLexemeSelectionRange(editor, cursorOffset, isWordPartCondition)) != null && !range.equals((Object)camelRange)) {
            ranges.add(range);
        }
    }

    @Nullable
    private static TextRange getCamelSelectionRange(CharSequence editorText, int cursorOffset, CharCondition isWordPartCondition) {
        if (cursorOffset < 0 || cursorOffset >= editorText.length()) {
            return null;
        }
        if (cursorOffset > 0 && !isWordPartCondition.value(editorText.charAt(cursorOffset)) && isWordPartCondition.value(editorText.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if (isWordPartCondition.value(editorText.charAt(cursorOffset))) {
            int start;
            int end = cursorOffset + 1;
            int textLen = editorText.length();
            for (start = cursorOffset; start > 0 && isWordPartCondition.value(editorText.charAt(start - 1)) && !EditorActionUtil.isHumpBound(editorText, start, true); --start) {
            }
            while (end < textLen && isWordPartCondition.value(editorText.charAt(end)) && !EditorActionUtil.isHumpBound(editorText, end, false)) {
                ++end;
            }
            if (start + 1 < end) {
                return new TextRange(start, end);
            }
        }
        return null;
    }

    @Nullable
    public static TextRange getWordOrLexemeSelectionRange(@NotNull Editor editor, int cursorOffset, @NotNull CharCondition isWordPartCondition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordUtil", "getWordOrLexemeSelectionRange"));
        }
        if (isWordPartCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isWordPartCondition", "com/intellij/codeInsight/editorActions/SelectWordUtil", "getWordOrLexemeSelectionRange"));
        }
        return SelectWordUtil.getWordOrLexemeSelectionRange(editor, editor.getDocument().getImmutableCharSequence(), cursorOffset, isWordPartCondition);
    }

    @Nullable
    public static TextRange getWordSelectionRange(@NotNull CharSequence editorText, int cursorOffset, @NotNull CharCondition isWordPartCondition) {
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/SelectWordUtil", "getWordSelectionRange"));
        }
        if (isWordPartCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isWordPartCondition", "com/intellij/codeInsight/editorActions/SelectWordUtil", "getWordSelectionRange"));
        }
        return SelectWordUtil.getWordOrLexemeSelectionRange(null, editorText, cursorOffset, isWordPartCondition);
    }

    @Nullable
    private static TextRange getWordOrLexemeSelectionRange(@Nullable Editor editor, @NotNull CharSequence editorText, int cursorOffset, @NotNull CharCondition isWordPartCondition) {
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/SelectWordUtil", "getWordOrLexemeSelectionRange"));
        }
        if (isWordPartCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isWordPartCondition", "com/intellij/codeInsight/editorActions/SelectWordUtil", "getWordOrLexemeSelectionRange"));
        }
        int length = editorText.length();
        if (length == 0) {
            return null;
        }
        if (cursorOffset == length || cursorOffset > 0 && !isWordPartCondition.value(editorText.charAt(cursorOffset)) && isWordPartCondition.value(editorText.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if (isWordPartCondition.value(editorText.charAt(cursorOffset))) {
            int start;
            int end = cursorOffset;
            for (start = cursorOffset; start > 0 && isWordPartCondition.value(editorText.charAt(start - 1)) && (editor == null || !EditorActionUtil.isLexemeBoundary(editor, start)); --start) {
            }
            while (end < length && isWordPartCondition.value(editorText.charAt(end)) && (end == start || editor == null || !EditorActionUtil.isLexemeBoundary(editor, end))) {
                ++end;
            }
            return new TextRange(start, end);
        }
        return null;
    }

    public static void processRanges(@Nullable PsiElement element, CharSequence text2, int cursorOffset, Editor editor, Processor<TextRange> consumer) {
        if (element == null) {
            return;
        }
        PsiFile file2 = element.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        SelectWordUtil.processInFile(element, consumer, text2, cursorOffset, editor);
        for (PsiFile psiFile : viewProvider.getAllFiles()) {
            PsiElement elementAt;
            ASTNode nodeAt;
            FileASTNode fileNode;
            if (psiFile == file2 || (fileNode = psiFile.getNode()) == null || (nodeAt = fileNode.findLeafElementAt(element.getTextOffset())) == null) continue;
            for (elementAt = nodeAt.getPsi(); !(elementAt instanceof PsiFile) && elementAt != null && !elementAt.getTextRange().contains(element.getTextRange()); elementAt = elementAt.getParent()) {
            }
            if (elementAt == null) continue;
            SelectWordUtil.processInFile(elementAt, consumer, text2, cursorOffset, editor);
        }
    }

    private static void processInFile(@NotNull PsiElement element, Processor<TextRange> consumer, CharSequence text2, int cursorOffset, Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/SelectWordUtil", "processInFile"));
        }
        DumbService.getInstance((Project)element.getProject()).withAlternativeResolveEnabled(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/SelectWordUtil", "lambda$processInFile$0"));
            }
            for (PsiElement e = element; e != null && !(e instanceof PsiFile); e = e.getParent()) {
                if (!SelectWordUtil.processElement(e, consumer, text2, cursorOffset, editor)) continue;
                return;
            }
        });
    }

    private static boolean processElement(@NotNull PsiElement element, Processor<TextRange> processor2, CharSequence text2, int cursorOffset, Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/SelectWordUtil", "processElement"));
        }
        boolean stop2 = false;
        ExtendWordSelectionHandler[] extendWordSelectionHandlers = SelectWordUtil.getExtendWordSelectionHandlers();
        int minimalTextRangeLength = 0;
        LinkedList availableSelectioners = ContainerUtil.newLinkedList();
        for (ExtendWordSelectionHandler selectioner : extendWordSelectionHandlers) {
            if (!selectioner.canSelect(element)) continue;
            int selectionerMinimalTextRange = selectioner instanceof ExtendWordSelectionHandlerBase ? ((ExtendWordSelectionHandlerBase)selectioner).getMinimalTextRangeLength(element, text2, cursorOffset) : 0;
            minimalTextRangeLength = Math.max(minimalTextRangeLength, selectionerMinimalTextRange);
            availableSelectioners.add(selectioner);
        }
        for (ExtendWordSelectionHandler selectioner : availableSelectioners) {
            List<TextRange> ranges = SelectWordUtil.askSelectioner(element, text2, cursorOffset, editor, selectioner);
            if (ranges == null) continue;
            for (TextRange range : ranges) {
                if (range == null || range.getLength() < minimalTextRangeLength) continue;
                stop2 |= processor2.process((Object)range);
            }
        }
        return stop2;
    }

    @Nullable
    private static List<TextRange> askSelectioner(@NotNull PsiElement element, CharSequence text2, int cursorOffset, Editor editor, ExtendWordSelectionHandler selectioner) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/SelectWordUtil", "askSelectioner"));
        }
        try {
            long stamp = editor.getDocument().getModificationStamp();
            List ranges = selectioner.select(element, text2, cursorOffset, editor);
            if (stamp != editor.getDocument().getModificationStamp()) {
                throw new AssertionError((Object)("Selectioner " + selectioner + " has changed the document"));
            }
            return ranges;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public static void addWordHonoringEscapeSequences(CharSequence editorText, TextRange literalTextRange, int cursorOffset, Lexer lexer, List<TextRange> result2) {
        lexer.start(editorText, literalTextRange.getStartOffset(), literalTextRange.getEndOffset());
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenStart() <= cursorOffset && cursorOffset < lexer.getTokenEnd()) {
                if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) {
                    result2.add(new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()));
                    break;
                }
                TextRange word = SelectWordUtil.getWordSelectionRange(editorText, cursorOffset, JAVA_IDENTIFIER_PART_CONDITION);
                if (word == null) break;
                result2.add(new TextRange(Math.max(word.getStartOffset(), lexer.getTokenStart()), Math.min(word.getEndOffset(), lexer.getTokenEnd())));
                break;
            }
            lexer.advance();
        }
    }

    public static interface CharCondition {
        public boolean value(char var1);
    }
}

