/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;

public class XmlEditUtil {
    public static CodeStyleSettings.QuoteStyle quoteStyle(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/XmlEditUtil", "quoteStyle"));
        }
        PsiElement context = file2.getContext();
        CodeStyleSettings.QuoteStyle style = CodeStyleSettingsManager.getInstance((Project)file2.getProject()).getCurrentSettings().HTML_QUOTE_STYLE;
        if (context != null && !style.quote.isEmpty() && context.getText().startsWith(style.quote)) {
            return style == CodeStyleSettings.QuoteStyle.Double ? CodeStyleSettings.QuoteStyle.Single : CodeStyleSettings.QuoteStyle.Double;
        }
        return style;
    }

    @NotNull
    public static String getAttributeQuote(boolean html) {
        String string = html ? CodeStyleSchemes.getInstance().getCurrentScheme().getCodeStyleSettings().HTML_QUOTE_STYLE.quote : "\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlEditUtil", "getAttributeQuote"));
        }
        return string;
    }
}

