/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.fillParagraph;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParagraphFillHandler {
    protected void performOnElement(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "performOnElement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "performOnElement"));
        }
        Document document = editor.getDocument();
        TextRange textRange = this.getTextRange(element, editor);
        if (textRange.isEmpty()) {
            return;
        }
        String text2 = textRange.substring(element.getContainingFile().getText());
        List subStrings = StringUtil.split((String)text2, (String)"\n", (boolean)true);
        String prefix = this.getPrefix(element);
        String postfix = this.getPostfix(element);
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPrefix(element, text2, stringBuilder);
        for (String string : subStrings) {
            String startTrimmed = StringUtil.trimStart((String)string.trim(), (String)prefix.trim());
            String str = StringUtil.trimEnd((String)startTrimmed, (String)postfix.trim());
            String finalString = str.trim();
            if (StringUtil.isEmptyOrSpaces((String)finalString)) continue;
            stringBuilder.append(finalString).append(" ");
        }
        this.appendPostfix(element, text2, stringBuilder);
        String replacementText = stringBuilder.toString();
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "lambda$performOnElement$0"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "lambda$performOnElement$0"));
            }
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replacementText);
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleSettingsManager.getSettings((Project)element.getProject()), element.getLanguage());
            PsiFile file2 = element.getContainingFile();
            FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyleSettingsManager.getSettings((Project)file2.getProject()));
            List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), TextRange.create((int)0, (int)document.getTextLength()));
            codeFormatter.doWrapLongLinesIfNecessary(editor, element.getProject(), document, textRange.getStartOffset(), textRange.getStartOffset() + replacementText.length() + 1, enabledRanges);
        }, null, (Object)document);
    }

    protected void appendPostfix(@NotNull PsiElement element, @NotNull String text2, @NotNull StringBuilder stringBuilder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "appendPostfix"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "appendPostfix"));
        }
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "appendPostfix"));
        }
        String postfix = this.getPostfix(element);
        if (text2.endsWith(postfix.trim())) {
            stringBuilder.append(postfix);
        }
    }

    protected void appendPrefix(@NotNull PsiElement element, @NotNull String text2, @NotNull StringBuilder stringBuilder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "appendPrefix"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "appendPrefix"));
        }
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "appendPrefix"));
        }
        String prefix = this.getPrefix(element);
        if (text2.startsWith(prefix.trim())) {
            stringBuilder.append(prefix);
        }
    }

    private TextRange getTextRange(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getTextRange"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getTextRange"));
        }
        int startOffset = this.getStartOffset(element, editor);
        int endOffset = this.getEndOffset(element, editor);
        return new UnfairTextRange(startOffset, endOffset);
    }

    private int getStartOffset(@NotNull PsiElement element, @NotNull Editor editor) {
        int lineNumber;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getStartOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getStartOffset"));
        }
        if (this.isBunchOfElement(element)) {
            PsiElement firstElement = this.getFirstElement(element);
            return firstElement != null ? firstElement.getTextRange().getStartOffset() : element.getTextRange().getStartOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element.getTextOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); --lineNumber) {
            String text2 = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text2)) continue;
            ++lineNumber;
            break;
        }
        int lineStartOffset = lineNumber == document.getLineNumber(elementTextOffset) ? elementTextOffset : document.getLineStartOffset(lineNumber);
        String lineText = document.getText(TextRange.create((int)lineStartOffset, (int)document.getLineEndOffset(lineNumber)));
        int shift = StringUtil.findFirst((CharSequence)lineText, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        return lineStartOffset + shift;
    }

    protected boolean isBunchOfElement(PsiElement element) {
        return element instanceof PsiComment;
    }

    private int getEndOffset(@NotNull PsiElement element, @NotNull Editor editor) {
        int lineNumber;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getEndOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getEndOffset"));
        }
        if (this.isBunchOfElement(element)) {
            PsiElement next = this.getLastElement(element);
            return next != null ? next.getTextRange().getEndOffset() : element.getTextRange().getEndOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element.getTextRange().getEndOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); ++lineNumber) {
            String text2 = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text2)) continue;
            --lineNumber;
            break;
        }
        return document.getLineEndOffset(lineNumber);
    }

    @Nullable
    private PsiElement getFirstElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getFirstElement"));
        }
        IElementType elementType = element.getNode().getElementType();
        PsiElement result2 = element;
        for (PsiElement prevSibling = element.getPrevSibling(); prevSibling != null && (prevSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(prevSibling) && StringUtil.countChars((CharSequence)prevSibling.getText(), (char)'\n') <= 1); prevSibling = prevSibling.getPrevSibling()) {
            String text2 = prevSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text2 = StringUtil.trimStart((String)text2.trim(), (String)prefix.trim());
            text2 = StringUtil.trimEnd((String)text2, (String)postfix);
            if (prevSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text2)) break;
            if (!prevSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = prevSibling;
        }
        return result2;
    }

    @Nullable
    private PsiElement getLastElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getLastElement"));
        }
        IElementType elementType = element.getNode().getElementType();
        PsiElement result2 = element;
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null && (nextSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(nextSibling) && StringUtil.countChars((CharSequence)nextSibling.getText(), (char)'\n') <= 1); nextSibling = nextSibling.getNextSibling()) {
            String text2 = nextSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text2 = StringUtil.trimStart((String)text2.trim(), (String)prefix.trim());
            text2 = StringUtil.trimEnd((String)text2, (String)postfix);
            if (nextSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text2)) break;
            if (!nextSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = nextSibling;
        }
        return result2;
    }

    protected boolean atWhitespaceToken(@Nullable PsiElement element) {
        return element instanceof PsiWhiteSpace;
    }

    protected boolean isAvailableForElement(@Nullable PsiElement element) {
        return element != null;
    }

    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof PsiPlainTextFile;
    }

    @NotNull
    protected String getPrefix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getPrefix"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getPrefix"));
        }
        return "";
    }

    @NotNull
    protected String getPostfix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getPostfix"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/fillParagraph/ParagraphFillHandler", "getPostfix"));
        }
        return "";
    }
}

