/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AutoIndentLinesHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.AutoIndentLinesHandler");

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        int endOffset;
        int startOffset;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/AutoIndentLinesHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/AutoIndentLinesHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/AutoIndentLinesHandler", "invoke"));
        }
        Document document = editor.getDocument();
        boolean hasSelection = editor.getSelectionModel().hasSelection();
        if (hasSelection) {
            startOffset = editor.getSelectionModel().getSelectionStart();
            endOffset = editor.getSelectionModel().getSelectionEnd() - 1;
        } else {
            startOffset = endOffset = editor.getCaretModel().getOffset();
        }
        int line1 = editor.offsetToLogicalPosition((int)startOffset).line;
        int col = editor.getCaretModel().getLogicalPosition().column;
        try {
            AutoIndentLinesHandler.adjustLineIndent(file2, document, startOffset, endOffset, line1, project2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        if (!hasSelection && line1 < document.getLineCount() - 1) {
            if (document.getLineStartOffset(line1 + 1) + col >= document.getTextLength()) {
                col = document.getLineEndOffset(line1 + 1) - document.getLineStartOffset(line1 + 1);
            }
            LogicalPosition pos = new LogicalPosition(line1 + 1, col);
            editor.getCaretModel().moveToLogicalPosition(pos);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static void adjustLineIndent(PsiFile file2, Document document, int startOffset, int endOffset, int line, Project project2) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        if (startOffset == endOffset) {
            int lineStart = document.getLineStartOffset(line);
            if (codeStyleManager.isLineToBeIndented(file2, lineStart)) {
                codeStyleManager.adjustLineIndent(file2, lineStart);
            }
        } else {
            codeStyleManager.adjustLineIndent(file2, new TextRange(DocumentUtil.getLineStartOffset(startOffset, document), endOffset));
        }
    }
}

