/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.exception.GenerateCodeException;

public abstract class GenerateMembersHandlerBase
implements CodeInsightActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersHandlerBase");
    private final String myChooserTitle;
    protected boolean myToCopyJavaDoc;

    public GenerateMembersHandlerBase(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "isAvailableForQuickList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "isAvailableForQuickList"));
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(file2.getProject(), editor, file2, false);
        return aClass != null && this.hasMembers(aClass);
    }

    protected boolean hasMembers(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "hasMembers"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "invoke"));
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project2)) {
            return;
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(project2, editor, file2, false);
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        LOG.assertTrue(aClass.getContainingFile() != null);
        try {
            ClassMember[] members = this.chooseOriginalMembers(aClass, project2, editor);
            if (members == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "lambda$invoke$1"));
                }
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "lambda$invoke$1"));
                }
                int offset = editor.getCaretModel().getOffset();
                try {
                    this.doGenerate(project2, editor, aClass, members);
                }
                catch (GenerateCodeException e) {
                    String message2 = e.getMessage();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "lambda$null$0"));
                        }
                        if (!editor.isDisposed()) {
                            editor.getCaretModel().moveToOffset(offset);
                            HintManager.getInstance().showErrorHint(editor, message2);
                        }
                    }, project2.getDisposed());
                }
            }, null, null);
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
    }

    private void doGenerate(Project project2, Editor editor, PsiClass aClass, ClassMember[] members) {
        int offset = editor.getCaretModel().getOffset();
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        CharSequence docText = document.getCharsSequence();
        String textBeforeCaret = docText.subSequence(lineStartOffset, offset).toString();
        String afterCaret = docText.subSequence(offset, document.getLineEndOffset(line)).toString();
        PsiElement lBrace = aClass.getLBrace();
        if (textBeforeCaret.trim().length() > 0 && StringUtil.isEmptyOrSpaces((String)afterCaret) && (lBrace == null || lBrace.getTextOffset() < offset) && !editor.getSelectionModel().hasSelection()) {
            WriteAction.run(() -> EnterAction.insertNewLineAtCaret(editor));
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            offset = editor.getCaretModel().getOffset();
            col = editor.getCaretModel().getLogicalPosition().column;
            line = editor.getCaretModel().getLogicalPosition().line;
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        int finalOffset = offset;
        List newMembers = (List)WriteAction.compute(() -> GenerateMembersUtil.insertMembersAtOffset(aClass, finalOffset, this.generateMemberPrototypes(aClass, members)));
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, col));
        if (newMembers.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, this.getNothingFoundMessage());
            }
            return;
        }
        ArrayList<PsiMember> elements = new ArrayList<PsiMember>();
        for (GenerationInfo member : newMembers) {
            PsiMember psiMember;
            if (member instanceof TemplateGenerationInfo || (psiMember = member.getPsiMember()) == null) continue;
            elements.add(psiMember);
        }
        GlobalInspectionContextBase.cleanupElements(project2, null, elements.toArray(new PsiElement[elements.size()]));
        ArrayList<TemplateGenerationInfo> templates = new ArrayList<TemplateGenerationInfo>();
        for (GenerationInfo member : newMembers) {
            if (!(member instanceof TemplateGenerationInfo)) continue;
            templates.add((TemplateGenerationInfo)member);
        }
        if (!templates.isEmpty()) {
            GenerateMembersHandlerBase.runTemplates(project2, editor, templates, 0);
        } else if (!newMembers.isEmpty()) {
            ((GenerationInfo)newMembers.get(0)).positionCaret(editor, false);
        }
    }

    protected String getNothingFoundMessage() {
        return "Nothing found to insert";
    }

    private static void runTemplates(final Project myProject, final Editor editor, final List<TemplateGenerationInfo> templates, final int index) {
        TemplateGenerationInfo info = templates.get(index);
        Template template = info.getTemplate();
        PsiMethod element = info.getPsiMember();
        TextRange range = element.getTextRange();
        WriteAction.run(() -> editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset()));
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        TemplateManager.getInstance(myProject).startTemplate(editor, template, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                if (index + 1 < templates.size()) {
                    ApplicationManager.getApplication().invokeLater(() -> new WriteCommandAction(myProject, new PsiFile[0]){

                        protected void run(@NotNull Result result2) throws Throwable {
                            if (result2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase$1$1", "run"));
                            }
                            GenerateMembersHandlerBase.runTemplates(myProject, editor, templates, index + 1);
                        }
                    }.execute());
                }
            }
        });
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project2) {
        ClassMember[] allMembers = this.getAllOriginalMembers(aClass);
        return this.chooseMembers(allMembers, false, false, project2, null);
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project2, Editor editor) {
        return this.chooseOriginalMembers(aClass, project2);
    }

    @Nullable
    protected ClassMember[] chooseMembers(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project2, @Nullable Editor editor) {
        MemberChooser<ClassMember> chooser = this.createMembersChooser(members, allowEmptySelection, copyJavadocCheckbox, project2);
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            ClassMember preselection = null;
            for (ClassMember member : members) {
                TextRange textRange;
                Object owner2;
                if (!(member instanceof PsiElementClassMember) || (owner2 = ((PsiElementClassMember)member).getElement()) == null || (textRange = owner2.getTextRange()) == null || !textRange.contains(offset)) continue;
                preselection = member;
                break;
            }
            if (preselection != null) {
                chooser.selectElements(new ClassMember[]{preselection});
            }
        }
        chooser.show();
        this.myToCopyJavaDoc = chooser.isCopyJavadoc();
        List<ClassMember> list2 = chooser.getSelectedElements();
        return list2 == null ? null : list2.toArray(new ClassMember[list2.size()]);
    }

    protected MemberChooser<ClassMember> createMembersChooser(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project2) {
        MemberChooser<ClassMember> chooser = new MemberChooser<ClassMember>(members, allowEmptySelection, true, project2, this.getHeaderPanel(project2), this.getOptionControls()){

            @Nullable
            protected String getHelpId() {
                return GenerateMembersHandlerBase.this.getHelpId();
            }
        };
        chooser.setTitle(this.myChooserTitle);
        chooser.setCopyJavadocVisible(copyJavadocCheckbox);
        return chooser;
    }

    @Nullable
    protected JComponent getHeaderPanel(Project project2) {
        return null;
    }

    @Nullable
    protected JComponent[] getOptionControls() {
        return null;
    }

    protected String getHelpId() {
        return null;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        ArrayList array = new ArrayList();
        for (ClassMember member : members) {
            Object[] prototypes = this.generateMemberPrototypes(aClass, member);
            if (prototypes == null) continue;
            ContainerUtil.addAll(array, (Object[])prototypes);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "generateMemberPrototypes"));
        }
        return arrayList;
    }

    protected abstract ClassMember[] getAllOriginalMembers(PsiClass var1);

    protected abstract GenerationInfo[] generateMemberPrototypes(PsiClass var1, ClassMember var2) throws IncorrectOperationException;

    public boolean startInWriteAction() {
        return false;
    }
}

