/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.AutoIndentLinesHandler;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoIndentLinesAction
extends BaseCodeInsightAction
implements DumbAware {
    @Override
    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project2, boolean forUpdate) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/generation/actions/AutoIndentLinesAction", "getEditor"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/AutoIndentLinesAction", "getEditor"));
        }
        Editor editor = this.getBaseEditor(dataContext, project2);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getCachedPsiFile(document);
        if (psiFile == null) {
            return editor;
        }
        if (!forUpdate) {
            documentManager.commitAllDocuments();
        }
        int startLineOffset = DocumentUtil.getLineStartOffset(editor.getSelectionModel().getSelectionStart(), document);
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile, startLineOffset);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        AutoIndentLinesHandler autoIndentLinesHandler = new AutoIndentLinesHandler();
        if (autoIndentLinesHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/AutoIndentLinesAction", "getHandler"));
        }
        return autoIndentLinesHandler;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/AutoIndentLinesAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/AutoIndentLinesAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/AutoIndentLinesAction", "isValidForFile"));
        }
        FileType fileType = file2.getFileType();
        return fileType instanceof LanguageFileType && LanguageFormatting.INSTANCE.forContext(((LanguageFileType)fileType).getLanguage(), (PsiElement)file2) != null;
    }
}

