/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.codeInsight.generation.actions.GenerateCreateUIHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.HashSet;

public class GenerateCreateUIAction
extends BaseGenerateAction {
    public GenerateCreateUIAction() {
        super((CodeInsightActionHandler)new GenerateCreateUIHandler());
    }

    public boolean isValidForClass(PsiClass targetClass) {
        PsiModifierList list2 = targetClass.getModifierList();
        return list2 != null && !list2.hasModifierProperty("abstract") && !GenerateCreateUIAction.hasCreateUIMethod(targetClass) && GenerateCreateUIAction.isComponentUI(targetClass, (HashSet<PsiClass>)new HashSet());
    }

    private static boolean hasCreateUIMethod(PsiClass aClass) {
        for (PsiMethod method : aClass.findMethodsByName("createUI", false)) {
            PsiParameter[] parameters2;
            if (!method.hasModifierProperty("static") || (parameters2 = method.getParameterList().getParameters()).length != 1) continue;
            PsiType type2 = parameters2[0].getType();
            PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)type2);
            return typeClass != null && "javax.swing.JComponent".equals(typeClass.getQualifiedName());
        }
        return false;
    }

    private static boolean isComponentUI(PsiClass aClass, HashSet<PsiClass> classes2) {
        while (aClass != null) {
            if (!classes2.add((Object)aClass)) {
                return false;
            }
            if ("javax.swing.plaf.ComponentUI".equals(aClass.getQualifiedName())) {
                return true;
            }
            aClass = aClass.getSuperClass();
        }
        return false;
    }
}

