/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.MixinExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationRangeUtil {
    @NotNull
    public static TextRange getDeclarationRange(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/hint/DeclarationRangeUtil", "getDeclarationRange"));
        }
        TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        assert (textRange != null) : "Declaration range is invalid for " + container.getClass();
        TextRange textRange2 = textRange;
        if (textRange2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/DeclarationRangeUtil", "getDeclarationRange"));
        }
        return textRange2;
    }

    @Nullable
    public static TextRange getPossibleDeclarationAtRange(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/hint/DeclarationRangeUtil", "getPossibleDeclarationAtRange"));
        }
        DeclarationRangeHandler handler2 = (DeclarationRangeHandler)MixinExtension.getInstance((ExtensionPointName)DeclarationRangeHandler.EP_NAME, (Object)container);
        return handler2 != null ? handler2.getDeclarationRange(container) : null;
    }
}

