/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HintUtil {
    @Deprecated
    public static final Color INFORMATION_COLOR = new JBColor(new Color(253, 254, 226), new Color(5066577));
    @Deprecated
    public static final Color QUESTION_COLOR = new JBColor(new Color(181, 208, 251), new Color(55, 108, 137));
    @Deprecated
    public static final Color ERROR_COLOR = new JBColor(new Color(255, 220, 220), new Color(7870258));
    public static final ColorKey INFORMATION_COLOR_KEY = ColorKey.createColorKey((String)"INFORMATION_HINT", (Color)INFORMATION_COLOR);
    public static final ColorKey QUESTION_COLOR_KEY = ColorKey.createColorKey((String)"QUESTION_HINT", (Color)QUESTION_COLOR);
    public static final ColorKey ERROR_COLOR_KEY = ColorKey.createColorKey((String)"ERROR_HINT", (Color)ERROR_COLOR);
    public static final Color QUESTION_UNDERSCORE_COLOR = JBColor.foreground();

    private HintUtil() {
    }

    @NotNull
    public static Color getInformationColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)INFORMATION_COLOR_KEY), (Object)INFORMATION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "getInformationColor"));
        }
        return color;
    }

    @NotNull
    public static Color getQuestionColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)QUESTION_COLOR_KEY), (Object)QUESTION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "getQuestionColor"));
        }
        return color;
    }

    @NotNull
    public static Color getErrorColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)ERROR_COLOR_KEY), (Object)ERROR_COLOR_KEY.getDefaultColor());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "getErrorColor"));
        }
        return color;
    }

    public static JComponent createInformationLabel(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintUtil", "createInformationLabel"));
        }
        return HintUtil.createInformationLabel(text2, null, null, null);
    }

    public static JComponent createInformationLabel(@NotNull String text2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<Consumer<String>> updatedTextConsumer) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintUtil", "createInformationLabel"));
        }
        HintHint hintHint = HintUtil.getInformationHint();
        HintLabel label = HintUtil.createLabel(text2, null, hintHint.getTextBackground(), hintHint);
        if (hyperlinkListener != null) {
            label.myPane.addHyperlinkListener(hyperlinkListener);
        }
        if (mouseListener != null) {
            label.myPane.addMouseListener(mouseListener);
        }
        if (updatedTextConsumer != null) {
            updatedTextConsumer.set(s -> {
                label.myPane.setText((String)s);
                label.setPreferredSize(null);
                label.myPane.setPreferredSize(null);
            });
        }
        return label;
    }

    @NotNull
    public static HintHint getInformationHint() {
        HintHint hintHint = new HintHint().setTextBg(HintUtil.getInformationColor()).setTextFg(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        if (hintHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "getInformationHint"));
        }
        return hintHint;
    }

    public static CompoundBorder createHintBorder() {
        return BorderFactory.createCompoundBorder(new ColoredSideBorder(Color.white, Color.white, Color.gray, Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @NotNull
    public static JComponent createInformationLabel(SimpleColoredText text2) {
        JComponent jComponent = HintUtil.createInformationLabel(text2, null);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "createInformationLabel"));
        }
        return jComponent;
    }

    public static JComponent createQuestionLabel(String text2) {
        Icon icon = AllIcons.General.Help_small;
        return HintUtil.createQuestionLabel(text2, icon);
    }

    public static JComponent createQuestionLabel(String text2, Icon icon) {
        Color bg = HintUtil.getQuestionColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        return HintUtil.createLabel(text2, icon, bg, hintHint);
    }

    @NotNull
    public static SimpleColoredComponent createInformationComponent() {
        SimpleColoredComponent component = new SimpleColoredComponent();
        component.setBackground(HintUtil.getInformationColor());
        component.setForeground(JBColor.foreground());
        component.setFont(HintUtil.getBoldFont());
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "createInformationComponent"));
        }
        return simpleColoredComponent;
    }

    @NotNull
    public static JComponent createInformationLabel(@NotNull SimpleColoredText text2, @Nullable Icon icon) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintUtil", "createInformationLabel"));
        }
        SimpleColoredComponent component = HintUtil.createInformationComponent();
        component.setIcon(icon);
        text2.appendToComponent((ColoredTextContainer)component);
        HintLabel hintLabel = new HintLabel(component);
        if (hintLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "createInformationLabel"));
        }
        return hintLabel;
    }

    public static JComponent createErrorLabel(String text2) {
        Color bg = HintUtil.getErrorColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        return HintUtil.createLabel(text2, null, bg, hintHint);
    }

    @NotNull
    private static HintLabel createLabel(String text2, @Nullable Icon icon, @NotNull Color color, @NotNull HintHint hintHint) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/hint/HintUtil", "createLabel"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/hint/HintUtil", "createLabel"));
        }
        HintLabel label = new HintLabel();
        label.setText(text2, hintHint);
        label.setIcon(icon);
        if (!hintHint.isAwtTooltip()) {
            label.setBorder(HintUtil.createHintBorder());
            label.setForeground(JBColor.foreground());
            label.setFont(HintUtil.getBoldFont());
            label.setBackground(color);
            label.setOpaque(true);
        }
        HintLabel hintLabel = label;
        if (hintLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "createLabel"));
        }
        return hintLabel;
    }

    private static Font getBoldFont() {
        return UIUtil.getLabelFont().deriveFont(1);
    }

    public static JLabel createAdComponent(String bottomText, Border border, @JdkConstants.HorizontalAlignment int alignment) {
        JLabel label = new JLabel();
        label.setText(bottomText);
        label.setHorizontalAlignment(alignment);
        label.setFont(label.getFont().deriveFont((float)(label.getFont().getSize() - 2)));
        if (bottomText != null) {
            label.setBorder(border);
        }
        return label;
    }

    @NotNull
    public static String prepareHintText(@NotNull String text2, @NotNull HintHint hintHint) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintUtil", "prepareHintText"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/hint/HintUtil", "prepareHintText"));
        }
        String string = HintUtil.prepareHintText(new Html(text2), hintHint);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintUtil", "prepareHintText"));
        }
        return string;
    }

    public static String prepareHintText(@NotNull Html text2, @NotNull HintHint hintHint) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintUtil", "prepareHintText"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/hint/HintUtil", "prepareHintText"));
        }
        String htmlBody = UIUtil.getHtmlBody((Html)text2);
        return String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)hintHint.getTextFont(), (Color)hintHint.getTextForeground(), (Color)hintHint.getLinkForeground(), (String)hintHint.getUlImg()), htmlBody);
    }

    private static class HintLabel
    extends JPanel {
        private JEditorPane myPane;
        private SimpleColoredComponent myColored;
        private JLabel myIcon;

        private HintLabel() {
            this.setLayout(new BorderLayout());
        }

        private HintLabel(@NotNull SimpleColoredComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/codeInsight/hint/HintUtil$HintLabel", "<init>"));
            }
            this();
            this.setText(component);
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.myPane != null) {
                return this.myPane.requestFocusInWindow();
            }
            if (this.myColored != null) {
                return this.myColored.requestFocusInWindow();
            }
            if (this.myIcon != null) {
                return this.myIcon.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public void setText(@NotNull SimpleColoredComponent colored) {
            if (colored == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colored", "com/intellij/codeInsight/hint/HintUtil$HintLabel", "setText"));
            }
            this.clearText();
            this.myColored = colored;
            this.add((Component)this.myColored, "Center");
            this.setOpaque(true);
            this.setBackground(colored.getBackground());
            this.revalidate();
            this.repaint();
        }

        public void setText(String s, HintHint hintHint) {
            this.clearText();
            if (s != null) {
                this.myPane = IdeTooltipManager.initPane(s, hintHint, null);
                this.add((Component)this.myPane, "Center");
            }
            this.setOpaque(true);
            this.setBackground(hintHint.getTextBackground());
            this.revalidate();
            this.repaint();
        }

        private void clearText() {
            if (this.myPane != null) {
                this.remove(this.myPane);
                this.myPane = null;
            }
            if (this.myColored != null) {
                this.remove((Component)this.myColored);
                this.myColored = null;
            }
        }

        public void setIcon(Icon icon) {
            if (this.myIcon != null) {
                this.remove(this.myIcon);
            }
            this.myIcon = new JLabel(icon, 0);
            this.myIcon.setVerticalAlignment(1);
            this.add((Component)this.myIcon, "West");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String toString() {
            return "Hint: text='" + (this.myPane != null ? this.myPane.getText() : "") + "'";
        }
    }
}

