/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hint.ExternalParameterInfoChangesProvider;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoController
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.ParameterInfoController");
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    private final RangeMarker myLbraceMarker;
    private final LightweightHint myHint;
    private final ParameterInfoComponent myComponent;
    private final boolean myKeepOnHintHidden;
    private final CaretListener myEditorCaretListener;
    @NotNull
    private final ParameterInfoHandler<Object, Object> myHandler;
    private final MyBestLocationPointProvider myProvider;
    private final Alarm myAlarm;
    private static final int DELAY = 200;
    private boolean myDisposed;
    private static final Key<List<ParameterInfoController>> ALL_CONTROLLERS_KEY = Key.create((String)"ParameterInfoController.ALL_CONTROLLERS_KEY");

    public static ParameterInfoController findControllerAtOffset(Editor editor, int offset) {
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(editor);
        for (int i2 = 0; i2 < allControllers.size(); ++i2) {
            ParameterInfoController controller = allControllers.get(i2);
            if (controller.myLbraceMarker.getStartOffset() != offset) continue;
            if (controller.myKeepOnHintHidden || controller.myHint.isVisible()) {
                return controller;
            }
            Disposer.dispose((Disposable)controller);
            --i2;
        }
        return null;
    }

    private static List<ParameterInfoController> getAllControllers(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ParameterInfoController", "getAllControllers"));
        }
        ArrayList array = (ArrayList)editor.getUserData(ALL_CONTROLLERS_KEY);
        if (array == null) {
            array = new ArrayList();
            editor.putUserData(ALL_CONTROLLERS_KEY, array);
        }
        return array;
    }

    public static boolean existsForEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ParameterInfoController", "existsForEditor"));
        }
        return !ParameterInfoController.getAllControllers(editor).isEmpty();
    }

    public static boolean isAlreadyShown(Editor editor, int lbraceOffset) {
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        return controller != null && controller.myHint.isVisible();
    }

    public ParameterInfoController(@NotNull Project project2, @NotNull Editor editor, int lbraceOffset, Object[] descriptors, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler handler2, boolean showHint2, boolean requestFocus) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        this.myAlarm = new Alarm();
        this.myProject = project2;
        this.myEditor = editor;
        this.myHandler = handler2;
        this.myProvider = new MyBestLocationPointProvider(editor);
        this.myLbraceMarker = editor.getDocument().createRangeMarker(lbraceOffset, lbraceOffset);
        this.myComponent = new ParameterInfoComponent(descriptors, editor, handler2, requestFocus);
        this.myHint = new LightweightHint(this.myComponent);
        this.myKeepOnHintHidden = !showHint2;
        this.myHint.setSelectingHint(true);
        this.myComponent.setParameterOwner(parameterOwner);
        this.myComponent.setHighlightedParameter(highlighted);
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.add(this);
        this.myEditorCaretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                ParameterInfoController.this.myAlarm.cancelAllRequests();
                ParameterInfoController.this.addAlarmRequest();
            }
        };
        this.myEditor.getCaretModel().addCaretListener(this.myEditorCaretListener);
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                ParameterInfoController.this.myAlarm.cancelAllRequests();
                ParameterInfoController.this.addAlarmRequest();
            }
        }, (Disposable)this);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)this);
        connection.subscribe(ExternalParameterInfoChangesProvider.TOPIC, (e, offset) -> {
            if (e != this.myEditor || this.myLbraceMarker.getStartOffset() != offset) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.addAlarmRequest();
        });
        PropertyChangeListener lookupListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Lookup lookup;
                if ("activeLookup".equals(evt.getPropertyName()) && (lookup = (Lookup)evt.getNewValue()) != null) {
                    ParameterInfoController.this.adjustPositionForLookup(lookup);
                }
            }
        };
        LookupManager.getInstance(project2).addPropertyChangeListener(lookupListener, this);
        if (this.myEditor instanceof EditorImpl) {
            Disposer.register((Disposable)((EditorImpl)this.myEditor).getDisposable(), (Disposable)this);
        }
        this.myComponent.update();
        if (showHint2) {
            this.showHint(requestFocus);
        }
        this.updateComponent();
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myHint.hide();
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.remove(this);
        this.myEditor.getCaretModel().removeCaretListener(this.myEditorCaretListener);
    }

    public void showHint(boolean requestFocus) {
        Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, this.myComponent.getParameterOwner(), this.myLbraceMarker.getStartOffset(), true, (short)2);
        HintHint hintHint = HintManagerImpl.createHintHint(this.myEditor, (Point)pos.getFirst(), this.myHint, (Short)pos.getSecond());
        hintHint.setExplicitClose(true);
        hintHint.setRequestFocus(requestFocus);
        Editor editorToShow = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : this.myEditor;
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editorToShow, (Point)pos.getFirst(), 129, 0, false, hintHint);
        this.updateComponent();
    }

    private void adjustPositionForLookup(@NotNull Lookup lookup) {
        JRootPane root;
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/hint/ParameterInfoController", "adjustPositionForLookup"));
        }
        if (this.myEditor.isDisposed()) {
            Disposer.dispose((Disposable)this);
            return;
        }
        if (!this.myHint.isVisible()) {
            if (!this.myKeepOnHintHidden) {
                Disposer.dispose((Disposable)this);
            }
            return;
        }
        IdeTooltip tooltip = this.myHint.getCurrentIdeTooltip();
        if (tooltip != null && (root = this.myEditor.getComponent().getRootPane()) != null) {
            Point p = tooltip.getShowingPoint().getPoint((Component)root.getLayeredPane());
            if (lookup.isPositionedAboveCaret()) {
                if (Balloon.Position.above == tooltip.getPreferredPosition()) {
                    this.myHint.pack();
                    this.myHint.updatePosition(Balloon.Position.below);
                    this.myHint.updateLocation(p.x, p.y + tooltip.getPositionChangeY());
                }
            } else if (Balloon.Position.below == tooltip.getPreferredPosition()) {
                this.myHint.pack();
                this.myHint.updatePosition(Balloon.Position.above);
                this.myHint.updateLocation(p.x, p.y - tooltip.getPositionChangeY());
            }
        }
    }

    private void addAlarmRequest() {
        Runnable request = () -> {
            if (!this.myDisposed && !this.myProject.isDisposed()) {
                PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                    try {
                        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(this::updateComponent);
                    }
                    catch (IndexNotReadyException e) {
                        LOG.info((Throwable)e);
                        Disposer.dispose((Disposable)this);
                    }
                });
            }
        };
        this.myAlarm.addRequest(request, 200, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    public void updateComponent() {
        if (this.myKeepOnHintHidden) {
            boolean removeHints = true;
            PsiElement owner2 = this.myComponent.getParameterOwner();
            if (owner2 != null && owner2.isValid()) {
                int caretOffset = this.myEditor.getCaretModel().getOffset();
                TextRange ownerTextRange = owner2.getTextRange();
                if (ownerTextRange != null) {
                    if (caretOffset > ownerTextRange.getStartOffset() && caretOffset < ownerTextRange.getEndOffset()) {
                        removeHints = false;
                    } else {
                        for (PsiElement element : owner2.getChildren()) {
                            if (!(element instanceof PsiErrorElement)) continue;
                            removeHints = false;
                            break;
                        }
                    }
                }
            }
            if (removeHints) {
                ParameterHintsPassFactory.forceHintsUpdateOnNextPass(this.myEditor);
                Disposer.dispose((Disposable)this);
                return;
            }
        }
        if (!(this.myHint.isVisible() || this.myKeepOnHintHidden || ApplicationManager.getApplication().isUnitTestMode())) {
            Disposer.dispose((Disposable)this);
            return;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject);
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        boolean noDelimiter = this.myHandler instanceof ParameterInfoHandlerWithTabActionSupport && ((ParameterInfoHandlerWithTabActionSupport)this.myHandler).getActualParameterDelimiterType() == TokenType.WHITE_SPACE;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int offset = noDelimiter ? caretOffset : CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        MyUpdateParameterInfoContext context = new MyUpdateParameterInfoContext(offset, file2);
        Object elementForUpdating = this.myHandler.findElementForUpdatingParameterInfo((UpdateParameterInfoContext)context);
        if (elementForUpdating != null) {
            this.myHandler.updateParameterInfo(elementForUpdating, (UpdateParameterInfoContext)context);
            if (!this.myDisposed && this.myHint.isVisible() && !this.myEditor.isDisposed() && this.myEditor.getComponent().getRootPane() != null) {
                this.myComponent.update();
                IdeTooltip tooltip = this.myHint.getCurrentIdeTooltip();
                short position = tooltip != null ? (short)ParameterInfoController.toShort(tooltip.getPreferredPosition()) : (short)2;
                Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, elementForUpdating instanceof PsiElement ? (PsiElement)elementForUpdating : null, caretOffset, true, position);
                HintManagerImpl.adjustEditorHintPosition(this.myHint, this.myEditor, (Point)pos.getFirst(), (Short)pos.getSecond());
            }
        } else {
            context.removeHint();
        }
    }

    @HintManager.PositionFlags
    private static short toShort(Balloon.Position position) {
        switch (position) {
            case above: {
                return 1;
            }
            case atLeft: {
                return 3;
            }
            case atRight: {
                return 4;
            }
        }
        return 2;
    }

    public static boolean hasPrevOrNextParameter(Editor editor, int lbraceOffset, boolean isNext) {
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        return controller != null && controller.getPrevOrNextParameterOffset(isNext) != -1;
    }

    public static void prevOrNextParameter(Editor editor, int lbraceOffset, boolean isNext) {
        int newOffset;
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        int n = newOffset = controller != null ? controller.getPrevOrNextParameterOffset(isNext) : -1;
        if (newOffset != -1) {
            controller.moveToParameterAtOffset(newOffset);
        }
    }

    private void moveToParameterAtOffset(int offset) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        Object argsList = ParameterInfoController.findArgumentList(file2, offset, -1);
        if (argsList == null && !ParameterInfoController.areParametersHintsEnabledOnCompletion()) {
            return;
        }
        offset = this.adjustOffsetToInlay(offset);
        this.myEditor.getCaretModel().moveToLogicalPosition(this.myEditor.offsetToLogicalPosition(offset).leanForward(true));
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        if (argsList != null) {
            this.myHandler.updateParameterInfo(argsList, (UpdateParameterInfoContext)new MyUpdateParameterInfoContext(offset, file2));
        }
    }

    private int adjustOffsetToInlay(int offset) {
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        String whitespaceChars = " \t";
        int whitespaceStart = CharArrayUtil.shiftBackward((CharSequence)text2, (int)offset, (String)whitespaceChars) + 1;
        int whitespaceEnd = CharArrayUtil.shiftForward((CharSequence)text2, (int)offset, (String)whitespaceChars);
        List inlays = this.myEditor.getInlayModel().getInlineElementsInRange(whitespaceStart, whitespaceEnd);
        for (Inlay inlay : inlays) {
            if (!ParameterHintsPresentationManager.getInstance().isParameterHint(inlay)) continue;
            return inlay.getOffset();
        }
        return offset;
    }

    private int getPrevOrNextParameterOffset(boolean isNext) {
        int currentParameterIndex;
        PsiElement argList;
        if (!(this.myHandler instanceof ParameterInfoHandlerWithTabActionSupport)) {
            return -1;
        }
        ParameterInfoHandlerWithTabActionSupport handler2 = (ParameterInfoHandlerWithTabActionSupport)this.myHandler;
        boolean noDelimiter = handler2.getActualParameterDelimiterType() == TokenType.WHITE_SPACE;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int offset = noDelimiter ? caretOffset : CharArrayUtil.shiftBackward((CharSequence)this.myEditor.getDocument().getCharsSequence(), (int)(caretOffset - 1), (String)" \t") + 1;
        int lbraceOffset = this.myLbraceMarker.getStartOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiElement psiElement = argList = lbraceOffset < offset ? (PsiElement)ParameterInfoController.findArgumentList(file2, offset, lbraceOffset) : null;
        if (argList == null) {
            return -1;
        }
        Object[] parameters2 = handler2.getActualParameters(argList);
        int n = currentParameterIndex = noDelimiter ? JBIterable.of((Object[])parameters2).indexOf(o -> o.getTextRange().containsOffset(offset)) : ParameterInfoUtils.getCurrentParameterIndex((ASTNode)argList.getNode(), (int)offset, (IElementType)handler2.getActualParameterDelimiterType());
        if (ParameterInfoController.areParametersHintsEnabledOnCompletion()) {
            if (currentParameterIndex < 0 || currentParameterIndex >= parameters2.length) {
                return -1;
            }
            int prevOrNextParameterIndex = currentParameterIndex + (isNext ? 1 : -1);
            if (prevOrNextParameterIndex < 0 || prevOrNextParameterIndex >= parameters2.length) {
                PsiElement parameterOwner = this.myComponent.getParameterOwner();
                return parameterOwner != null && parameterOwner.isValid() ? parameterOwner.getTextRange().getEndOffset() : -1;
            }
            return parameters2[prevOrNextParameterIndex].getTextRange().getStartOffset();
        }
        int prevOrNextParameterIndex = isNext && currentParameterIndex < parameters2.length - 1 ? currentParameterIndex + 1 : (!isNext && currentParameterIndex > 0 ? currentParameterIndex - 1 : -1);
        return prevOrNextParameterIndex != -1 ? parameters2[prevOrNextParameterIndex].getTextRange().getStartOffset() : -1;
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset, int lbraceOffset) {
        if (file2 == null) {
            return null;
        }
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(file2.getProject(), PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset), file2.getViewProvider().getBaseLanguage());
        if (handlers != null) {
            for (ParameterInfoHandler handler2 : handlers) {
                ParameterInfoHandlerWithTabActionSupport parameterInfoHandler2;
                PsiElement e;
                if (!(handler2 instanceof ParameterInfoHandlerWithTabActionSupport) || (e = ParameterInfoUtils.findArgumentList((PsiFile)file2, (int)offset, (int)lbraceOffset, (ParameterInfoHandlerWithTabActionSupport)(parameterInfoHandler2 = (ParameterInfoHandlerWithTabActionSupport)handler2))) == null) continue;
                return (E)e;
            }
        }
        return null;
    }

    public Object[] getObjects() {
        return this.myComponent.getObjects();
    }

    public Object getHighlighted() {
        return this.myComponent.getHighlighted();
    }

    /*
     * WARNING - void declaration
     */
    public static void waitForDelayedActions(@NotNull Editor editor, long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void unit;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ParameterInfoController", "waitForDelayedActions"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/codeInsight/hint/ParameterInfoController", "waitForDelayedActions"));
        }
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            List<ParameterInfoController> controllers = ParameterInfoController.getAllControllers(editor);
            boolean hasPendingRequests = false;
            for (ParameterInfoController controller : controllers) {
                if (controller.myAlarm.isEmpty()) continue;
                hasPendingRequests = true;
                break;
            }
            if (hasPendingRequests) {
                LockSupport.parkNanos(10000000L);
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            return;
        }
        throw new TimeoutException();
    }

    static Pair<Point, Short> chooseBestHintPosition(Project project2, Editor editor, LogicalPosition pos, LightweightHint hint, boolean awtTooltip, short preferredPosition) {
        int underSpace;
        int aboveSpace;
        boolean p2Ok;
        Point p2;
        Point p1;
        boolean isLookupShown;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Pair.pair((Object)new Point(), (Object)6);
        }
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        boolean bl = isLookupShown = LookupManager.getInstance(project2).getActiveLookup() != null;
        if (isLookupShown) {
            p1 = hintManager.getHintPosition(hint, editor, (short)2);
            p2 = hintManager.getHintPosition(hint, editor, (short)1);
        } else {
            p1 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
            p2 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
        }
        if (!awtTooltip) {
            p1.x = Math.min(p1.x, layeredPane.getWidth() - hintSize.width);
            p1.x = Math.max(p1.x, 0);
            p2.x = Math.min(p2.x, layeredPane.getWidth() - hintSize.width);
            p2.x = Math.max(p2.x, 0);
        }
        boolean p1Ok = p1.y + hintSize.height < layeredPane.getHeight();
        boolean bl2 = p2Ok = p2.y >= 0;
        if (isLookupShown) {
            if (p1Ok) {
                return new Pair((Object)p1, (Object)2);
            }
            if (p2Ok) {
                return new Pair((Object)p2, (Object)1);
            }
        } else {
            if (preferredPosition != 6) {
                if (preferredPosition == 1) {
                    if (p2Ok) {
                        return new Pair((Object)p2, (Object)1);
                    }
                } else if (preferredPosition == 2 && p1Ok) {
                    return new Pair((Object)p1, (Object)2);
                }
            }
            if (p1Ok) {
                return new Pair((Object)p1, (Object)2);
            }
            if (p2Ok) {
                return new Pair((Object)p2, (Object)1);
            }
        }
        return (aboveSpace = p2.y) > (underSpace = layeredPane.getHeight() - p1.y) ? new Pair((Object)new Point(p2.x, 0), (Object)2) : new Pair((Object)p1, (Object)1);
    }

    public static boolean areParameterTemplatesEnabledOnCompletion() {
        return Registry.is((String)"java.completion.argument.live.template") && !ParameterInfoController.areParametersHintsEnabledInternallyOnCompletion();
    }

    public static boolean areParametersHintsEnabledOnCompletion() {
        return Registry.is((String)"java.completion.argument.hints") && !Registry.is((String)"java.completion.argument.live.template") || ParameterInfoController.areParametersHintsEnabledInternallyOnCompletion();
    }

    private static boolean areParametersHintsEnabledInternallyOnCompletion() {
        return Registry.is((String)"java.completion.argument.hints.internal") && ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    }

    private static class MyBestLocationPointProvider {
        private final Editor myEditor;
        private int previousOffset = -1;
        private Point previousBestPoint;
        private Short previousBestPosition;

        public MyBestLocationPointProvider(Editor editor) {
            this.myEditor = editor;
        }

        @NotNull
        public Pair<Point, Short> getBestPointPosition(LightweightHint hint, PsiElement list2, int offset, boolean awtTooltip, short preferredPosition) {
            Pair position;
            TextRange range;
            if (list2 != null && !(range = list2.getTextRange()).contains(offset)) {
                offset = range.getStartOffset() + 1;
            }
            if (this.previousOffset == offset) {
                Pair pair2 = Pair.create((Object)this.previousBestPoint, (Object)this.previousBestPosition);
                if (pair2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$MyBestLocationPointProvider", "getBestPointPosition"));
                }
                return pair2;
            }
            boolean isMultiline = list2 != null && StringUtil.containsAnyChar((String)list2.getText(), (String)"\n\r");
            LogicalPosition pos = this.myEditor.offsetToLogicalPosition(offset).leanForward(true);
            if (!isMultiline) {
                position = ParameterInfoController.chooseBestHintPosition(this.myEditor.getProject(), this.myEditor, pos, hint, awtTooltip, preferredPosition);
            } else {
                Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, pos, (short)1);
                position = new Pair((Object)p, (Object)1);
            }
            this.previousBestPoint = (Point)position.getFirst();
            this.previousBestPosition = (Short)position.getSecond();
            this.previousOffset = offset;
            Pair pair3 = position;
            if (pair3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$MyBestLocationPointProvider", "getBestPointPosition"));
            }
            return pair3;
        }
    }

    public class MyUpdateParameterInfoContext
    implements UpdateParameterInfoContext {
        private final int myOffset;
        private final PsiFile myFile;

        public MyUpdateParameterInfoContext(int offset, PsiFile file2) {
            this.myOffset = offset;
            this.myFile = file2;
        }

        public int getParameterListStart() {
            return ParameterInfoController.this.myLbraceMarker.getStartOffset();
        }

        public int getOffset() {
            return this.myOffset;
        }

        public Project getProject() {
            return ParameterInfoController.this.myProject;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = ParameterInfoController.this.myEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$MyUpdateParameterInfoContext", "getEditor"));
            }
            return editor;
        }

        public void removeHint() {
            ParameterInfoController.this.myHint.hide();
            Disposer.dispose((Disposable)ParameterInfoController.this);
        }

        public void setParameterOwner(PsiElement o) {
            ParameterInfoController.this.myComponent.setParameterOwner(o);
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoController.this.myComponent.getParameterOwner();
        }

        public void setHighlightedParameter(Object method) {
            ParameterInfoController.this.myComponent.setHighlightedParameter(method);
        }

        public Object getHighlightedParameter() {
            return ParameterInfoController.this.myComponent.getHighlighted();
        }

        public void setCurrentParameter(int index) {
            ParameterInfoController.this.myComponent.setCurrentParameterIndex(index);
        }

        public boolean isUIComponentEnabled(int index) {
            return ParameterInfoController.this.myComponent.isEnabled(index);
        }

        public void setUIComponentEnabled(int index, boolean enabled) {
            ParameterInfoController.this.myComponent.setEnabled(index, enabled);
        }

        public Object[] getObjectsToView() {
            return ParameterInfoController.this.myComponent.getObjects();
        }
    }
}

