/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.hints.CallArgumentInfo;
import com.intellij.codeInsight.hints.CallInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.JavaInlayParameterHintsProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiNewExpressionImpl;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J+\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayHintsProvider;", "", "()V", "callInfo", "Lcom/intellij/codeInsight/hints/CallInfo;", "callExpression", "Lcom/intellij/psi/PsiCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "hintSet", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "info", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "hints", "isBuilderLike", "", "expression", "isMethodToShow", "isParamNameContainedInMethodName", "parameter", "Lcom/intellij/psi/PsiParameter;", "isShowForParamsWithSameType", "mergedHints", "results", "", "Lcom/intellij/psi/ResolveResult;", "(Lcom/intellij/psi/PsiCallExpression;[Lcom/intellij/psi/ResolveResult;)Ljava/util/Set;", "methodHints", "resolveResult", "java-impl"})
public final class JavaInlayHintsProvider {
    public static final JavaInlayHintsProvider INSTANCE;

    @NotNull
    public final Set<InlayInfo> hints(@NotNull PsiCallExpression callExpression) {
        Set<InlayInfo> set2;
        JavaResolveResult resolveResult;
        Intrinsics.checkParameterIsNotNull((Object)callExpression, (String)"callExpression");
        if (JavaMethodCallElement.hasCompletionHints(callExpression)) {
            return SetsKt.emptySet();
        }
        JavaResolveResult javaResolveResult = resolveResult = callExpression.resolveMethodGenerics();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult, (String)"resolveResult");
        Set<InlayInfo> hints = this.methodHints(callExpression, (ResolveResult)javaResolveResult);
        Collection collection = hints;
        if (!collection.isEmpty()) {
            return hints;
        }
        collection = callExpression;
        if (collection instanceof PsiMethodCallExpressionImpl) {
            JavaResolveResult[] javaResolveResultArray = ((PsiMethodCallExpressionImpl)callExpression).getMethodExpression().multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResultArray, (String)"callExpression.methodExp\u2026ssion.multiResolve(false)");
            set2 = this.mergedHints(callExpression, (ResolveResult[])javaResolveResultArray);
        } else if (collection instanceof PsiNewExpressionImpl) {
            ResolveResult[] resolveResultArray = ((PsiNewExpressionImpl)callExpression).getConstructorFakeReference().multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"callExpression.construct\u2026rence.multiResolve(false)");
            set2 = this.mergedHints(callExpression, resolveResultArray);
        } else {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<InlayInfo> mergedHints(PsiCallExpression callExpression, ResolveResult[] results) {
        void $receiver$iv$iv;
        InlayInfo inlayInfo;
        Collection collection;
        ResolveResult it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Object[] objectArray = results;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int j = 0; j < ((void)$receiver$iv$iv2).length; ++j) {
            void element$iv$iv = $receiver$iv$iv2[j];
            it = (ResolveResult)element$iv$iv;
            if (!(it.getElement() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (ResolveResult)item$iv$iv;
            collection = destination$iv$iv;
            inlayInfo = INSTANCE.methodHints(callExpression, it);
            collection.add(inlayInfo);
        }
        List resultSet = (List)destination$iv$iv;
        if (resultSet.isEmpty()) {
            return SetsKt.emptySet();
        }
        if (resultSet.size() == 1) {
            return (Set)CollectionsKt.first((List)resultSet);
        }
        PsiMethod chosenMethod = CompletionMemory.getChosenMethod((PsiCall)callExpression);
        if (chosenMethod != null) {
            CallInfo callInfo = this.callInfo(callExpression, chosenMethod);
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
            return this.hintSet(callInfo, psiSubstitutor);
        }
        Iterable $receiver$iv2 = resultSet;
        Iterator iterator$iv = $receiver$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void right;
            Object item$iv$iv;
            item$iv$iv = (Set)iterator$iv.next();
            Set left = (Set)accumulator$iv;
            accumulator$iv = CollectionsKt.intersect((Iterable)left, (Iterable)((Iterable)right));
        }
        $receiver$iv2 = (Iterable)accumulator$iv;
        iterator$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            InlayInfo $i$a$1$reduce = (InlayInfo)item$iv$iv;
            collection = destination$iv$iv2;
            inlayInfo = new InlayInfo(it2.getText(), it2.getOffset(), true);
            collection.add(inlayInfo);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    private final Set<InlayInfo> methodHints(PsiCallExpression callExpression, ResolveResult resolveResult) {
        JavaResolveResult substitutor;
        JavaResolveResult javaResolveResult;
        PsiElement element = resolveResult.getElement();
        ResolveResult resolveResult2 = resolveResult;
        if (!(resolveResult2 instanceof JavaResolveResult)) {
            resolveResult2 = null;
        }
        if ((javaResolveResult = (JavaResolveResult)resolveResult2) == null || (javaResolveResult = javaResolveResult.getSubstitutor()) == null) {
            javaResolveResult = substitutor = PsiSubstitutor.EMPTY;
        }
        if (element instanceof PsiMethod && this.isMethodToShow((PsiMethod)element, callExpression)) {
            CallInfo info = this.callInfo(callExpression, (PsiMethod)element);
            JavaResolveResult javaResolveResult2 = substitutor;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult2, (String)"substitutor");
            return this.hintSet(info, (PsiSubstitutor)javaResolveResult2);
        }
        return SetsKt.emptySet();
    }

    private final Set<InlayInfo> hintSet(CallInfo info, PsiSubstitutor substitutor) {
        Set resultSet = new LinkedHashSet();
        InlayInfo varargInlay = info.varargsInlay(substitutor);
        if (varargInlay != null) {
            resultSet.add(varargInlay);
        }
        if (this.isShowForParamsWithSameType()) {
            resultSet.addAll((Collection)info.sameTypeInlays());
        }
        resultSet.addAll((Collection)info.unclearInlays(substitutor));
        return resultSet;
    }

    private final boolean isShowForParamsWithSameType() {
        return JavaInlayParameterHintsProvider.Companion.getInstance().isShowForParamsWithSameType().get();
    }

    private final boolean isMethodToShow(PsiMethod method, PsiCallExpression callExpression) {
        PsiParameter[] params = method.getParameterList().getParameters();
        Object[] objectArray = params;
        if (objectArray.length == 0) {
            return false;
        }
        if (((Object[])params).length == 1) {
            JavaInlayParameterHintsProvider hintsProvider = JavaInlayParameterHintsProvider.Companion.getInstance();
            if (hintsProvider.isDoNotShowForBuilderLikeMethods().get() && this.isBuilderLike(callExpression, method)) {
                return false;
            }
            if (hintsProvider.isDoNotShowIfMethodNameContainsParameterName().get()) {
                PsiParameter psiParameter = params[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"params[0]");
                if (this.isParamNameContainedInMethodName(psiParameter, method)) {
                    return false;
                }
            }
        }
        return true;
    }

    private final boolean isBuilderLike(PsiCallExpression expression2, PsiMethod method) {
        if (expression2 instanceof PsiNewExpression) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)method.getReturnType());
        if (psiType == null) {
            return false;
        }
        PsiType returnType = psiType;
        Object object = method.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object calledMethodClassFqn = object;
        return returnType.equalsToText((String)calledMethodClassFqn);
    }

    private final boolean isParamNameContainedInMethodName(PsiParameter parameter, PsiMethod method) {
        String string = parameter.getName();
        if (string == null) {
            return false;
        }
        String parameterName = string;
        if (parameterName.length() > 1) {
            CharSequence charSequence = method.getName();
            String string2 = parameterName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"parameterName");
            return StringsKt.contains((CharSequence)charSequence, (CharSequence)string2, (boolean)true);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final CallInfo callInfo(PsiCallExpression callExpression, PsiMethod method) {
        void $receiver$iv$iv;
        void $receiver$iv;
        PsiParameter[] params = method.getParameterList().getParameters();
        PsiParameter psiParameter = (PsiParameter)ArraysKt.lastOrNull((Object[])params);
        boolean hasVarArg = psiParameter != null ? psiParameter.isVarArgs() : false;
        int regularParamsCount = hasVarArg ? ((Object[])params).length - 1 : ((Object[])params).length;
        PsiExpression[] psiExpressionArray = callExpression.getArgumentList();
        if (psiExpressionArray == null || (psiExpressionArray = psiExpressionArray.getExpressions()) == null) {
            psiExpressionArray = new PsiExpression[]{};
        }
        PsiExpression[] arguments = psiExpressionArray;
        Iterable iterable = ArraysKt.take((Object[])params, (int)regularParamsCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"arguments");
        Iterable iterable2 = CollectionsKt.zip((Iterable)iterable, (Object[])arguments);
        void var9_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object object = it.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
            PsiParameter psiParameter2 = (PsiParameter)object;
            Object object2 = it.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it.second");
            CallArgumentInfo callArgumentInfo = new CallArgumentInfo(psiParameter2, (PsiExpression)object2);
            collection.add(callArgumentInfo);
        }
        List regularArgInfos = (List)destination$iv$iv;
        PsiParameter varargParam = hasVarArg ? (PsiParameter)ArraysKt.last((Object[])params) : null;
        List varargExpressions = ArraysKt.drop((Object[])arguments, (int)regularParamsCount);
        return new CallInfo(regularArgInfos, varargParam, varargExpressions);
    }

    private JavaInlayHintsProvider() {
        INSTANCE = this;
    }

    static {
        new JavaInlayHintsProvider();
    }
}

