/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsUpdater {
    private static final Key<Boolean> REPEATED_PASS = Key.create((String)"RepeatedParameterHintsPass");
    private final ParameterHintsPresentationManager myHintsManager;
    private final TIntObjectHashMap<Caret> myCaretMap;
    private final TIntObjectHashMap<String> myNewHints;
    private final TIntObjectHashMap<String> myHintsToPreserve;
    private final Editor myEditor;
    private final List<InlayUpdateInfo> myUpdateList;

    public ParameterHintsUpdater(@NotNull Editor editor, @NotNull List<Inlay> inlays, @NotNull TIntObjectHashMap<String> newHints, @NotNull TIntObjectHashMap<String> hintsToPreserve) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "<init>"));
        }
        if (inlays == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlays", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "<init>"));
        }
        if (newHints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newHints", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "<init>"));
        }
        if (hintsToPreserve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintsToPreserve", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "<init>"));
        }
        this.myHintsManager = ParameterHintsPresentationManager.getInstance();
        this.myEditor = editor;
        this.myNewHints = newHints;
        this.myHintsToPreserve = hintsToPreserve;
        this.myCaretMap = new TIntObjectHashMap();
        List allCarets = this.myEditor.getCaretModel().getAllCarets();
        allCarets.forEach(caret -> {
            Caret cfr_ignored_0 = (Caret)this.myCaretMap.put(caret.getOffset(), caret);
        });
        this.myUpdateList = this.getInlayUpdates(inlays);
    }

    private List<InlayUpdateInfo> getInlayUpdates(List<Inlay> editorHints) {
        ArrayList updates = ContainerUtil.newArrayList();
        editorHints.forEach(editorHint -> {
            int offset = editorHint.getOffset();
            String newText = (String)this.myNewHints.remove(offset);
            if (this.delayRemoval((Inlay)editorHint) || this.myHintsManager.isPinned((Inlay)editorHint) || this.isPreserveHint((Inlay)editorHint, newText)) {
                return;
            }
            updates.add(new InlayUpdateInfo(offset, (Inlay)editorHint, newText));
        });
        Arrays.stream(this.myNewHints.keys()).forEach(offset -> updates.add(new InlayUpdateInfo(offset, null, (String)this.myNewHints.get(offset))));
        updates.sort(Comparator.comparing(update2 -> update2.offset));
        return updates;
    }

    private boolean isPreserveHint(@NotNull Inlay inlay, @Nullable String newText) {
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "isPreserveHint"));
        }
        if (newText == null) {
            newText = (String)this.myHintsToPreserve.get(inlay.getOffset());
        }
        String oldText = this.myHintsManager.getHintText(inlay);
        return Objects.equals(newText, oldText);
    }

    public void update() {
        boolean firstTime = this.myEditor.getUserData(REPEATED_PASS) == null;
        boolean isUpdateInBulkMode = this.myUpdateList.size() > 1000;
        DocumentUtil.executeInBulk(this.myEditor.getDocument(), isUpdateInBulkMode, () -> this.performHintsUpdate(firstTime, isUpdateInBulkMode));
        this.myEditor.putUserData(REPEATED_PASS, (Object)Boolean.TRUE);
    }

    private void performHintsUpdate(boolean firstTime, boolean isInBulkMode) {
        for (int infoIndex = 0; infoIndex < this.myUpdateList.size(); ++infoIndex) {
            boolean useAnimation;
            InlayUpdateInfo info = this.myUpdateList.get(infoIndex);
            String oldText = info.oldText;
            String newText = info.newText;
            if (oldText == null) {
                useAnimation = !firstTime && !this.isSameHintRemovedNear(newText, infoIndex) && !isInBulkMode;
                this.myHintsManager.addHint(this.myEditor, info.offset, newText, useAnimation, false);
                continue;
            }
            if (newText == null) {
                useAnimation = !this.isSameHintAddedNear(oldText, infoIndex) && !isInBulkMode;
                this.myHintsManager.deleteHint(this.myEditor, info.inlay, useAnimation);
                continue;
            }
            this.myHintsManager.replaceHint(this.myEditor, info.inlay, newText);
        }
    }

    private boolean isSameHintRemovedNear(@NotNull String text2, int index) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "isSameHintRemovedNear"));
        }
        return this.getInfosNear(index).anyMatch(info -> {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "lambda$isSameHintRemovedNear$5"));
            }
            return text2.equals(info.oldText);
        });
    }

    private boolean isSameHintAddedNear(@NotNull String text2, int index) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "isSameHintAddedNear"));
        }
        return this.getInfosNear(index).anyMatch(info -> {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/ParameterHintsUpdater", "lambda$isSameHintAddedNear$6"));
            }
            return text2.equals(info.newText);
        });
    }

    private Stream<InlayUpdateInfo> getInfosNear(int index) {
        ArrayList result2 = ContainerUtil.newArrayList();
        if (index > 0) {
            result2.add(this.myUpdateList.get(index - 1));
        }
        if (index + 1 < this.myUpdateList.size()) {
            result2.add(this.myUpdateList.get(index + 1));
        }
        return result2.stream();
    }

    private boolean delayRemoval(Inlay inlay) {
        int offset = inlay.getOffset();
        Caret caret = (Caret)this.myCaretMap.get(offset);
        if (caret == null) {
            return false;
        }
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        if (offset >= text2.length()) {
            return false;
        }
        char afterCaret = text2.charAt(offset);
        if (afterCaret != ',' && afterCaret != ')') {
            return false;
        }
        VisualPosition afterInlayPosition = this.myEditor.offsetToVisualPosition(offset, true, false);
        return caret.getVisualPosition().equals((Object)afterInlayPosition);
    }

    private static class InlayUpdateInfo {
        public final int offset;
        public final Inlay inlay;
        public final String newText;
        public final String oldText;

        public InlayUpdateInfo(int offset, @Nullable Inlay current, @Nullable String newText) {
            this.offset = offset;
            this.inlay = current;
            this.newText = newText;
            this.oldText = this.getHintText();
        }

        @Nullable
        private String getHintText() {
            return this.inlay != null ? ParameterHintsPresentationManager.getInstance().getHintText(this.inlay) : null;
        }
    }
}

