/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.PopupActionsKt$sam$Condition$33ac5b8e;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0011\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f*\u00020\u000eH\u0002\u001a\u0011\u0010\u0010\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f*\u00020\u000eH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\t*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\t*\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u0016\u001a\u00020\u000e*\u00020\u0017\u00a8\u0006\u0018"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasEditorParameterHintAtOffset", "", "isPossibleHintNearOffset", "refreshAllOpenEditors", "", "capitalize", "", "Lorg/jetbrains/annotations/NotNull;", "capitalizeFirstLetter", "hasDisabledOptionHintInfo", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "element", "Lcom/intellij/psi/PsiElement;", "isOwnsInlayInEditor", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "lang-impl"})
public final class PopupActionsKt {
    private static final boolean hasDisabledOptionHintInfo(@NotNull InlayParameterHintsProvider $receiver, PsiElement element) {
        HintInfo info = $receiver.getHintInfo(element);
        return info instanceof HintInfo.OptionInfo && !((HintInfo.OptionInfo)info).isOptionEnabled();
    }

    private static final boolean hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        Object v2;
        block2: {
            Iterable iterable;
            if (editor instanceof EditorWindow) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset);
            PsiElement psiElement = element;
            int startOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset;
            PsiElement psiElement2 = element;
            int endOffset = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() : offset;
            Iterable iterable2 = iterable = (Iterable)editor.getInlayModel().getInlineElementsInRange(startOffset, endOffset);
            for (Object t : iterable2) {
                Inlay it = (Inlay)t;
                if (!ParameterHintsPresentationManager.getInstance().isParameterHint(it)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2 != null;
    }

    private static final void refreshAllOpenEditors() {
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
        for (int j = 0; j < $receiver$iv.length; ++j) {
            Object element$iv = $receiver$iv[j];
            Project it = (Project)element$iv;
            PsiManager psiManager = PsiManager.getInstance((Project)it);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)it);
            Object[] $receiver$iv2 = fileEditorManager.getSelectedFiles();
            for (int k = 0; k < $receiver$iv2.length; ++k) {
                PsiFile psiFile;
                Object element$iv2 = $receiver$iv2[k];
                VirtualFile it2 = (VirtualFile)element$iv2;
                if (psiManager.findFile(it2) == null) continue;
                PsiFile it3 = psiFile;
                daemonCodeAnalyzer.restart(it3);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider = inlayParameterHintsProvider;
        Function1 isHintOwnedByElement2 = (Function1)new Function1<PsiElement, Boolean>(provider, editor){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ Editor $editor;

            public final boolean invoke(@NotNull PsiElement e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                return this.$provider.getHintInfo(e) != null && PopupActionsKt.isOwnsInlayInEditor(e, this.$editor);
            }
            {
                this.$provider = inlayParameterHintsProvider;
                this.$editor = editor;
                super(1);
            }
        };
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new PopupActionsKt$sam$Condition$33ac5b8e(isHintOwnedByElement2));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement method = psiElement2;
        return provider.getHintInfo(method);
    }

    public static final boolean isOwnsInlayInEditor(@NotNull PsiElement $receiver, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if ($receiver.getTextRange() == null) {
            return false;
        }
        int start = $receiver.getTextRange().isEmpty() ? $receiver.getTextRange().getStartOffset() : $receiver.getTextRange().getStartOffset() + 1;
        return !editor.getInlayModel().getInlineElementsInRange(start, $receiver.getTextRange().getEndOffset()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPossibleHintNearOffset(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return false;
        }
        InlayParameterHintsProvider hintProvider = inlayParameterHintsProvider;
        PsiElement element = file2.findElementAt(offset);
        int n = 0;
        int n2 = 3;
        if (n <= n2) {
            while (true) {
                void i2;
                if (element == null) {
                    return false;
                }
                List hints = hintProvider.getParameterHints(element);
                Collection collection = hints;
                if (!collection.isEmpty()) {
                    return true;
                }
                element = element.getParent();
                if (i2 == n2) break;
                ++i2;
            }
        }
        return false;
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getFullyQualifiedName() + '(' + CollectionsKt.joinToString$default((Iterable)$receiver.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    private static final String capitalize(@NotNull String $receiver) {
        return StringUtil.capitalizeWords((String)$receiver, (boolean)true);
    }

    private static final String capitalizeFirstLetter(@NotNull String $receiver) {
        return StringUtil.capitalize((String)$receiver);
    }

    @Nullable
    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset, @NotNull PsiFile file2, @NotNull Editor editor) {
        return PopupActionsKt.getHintInfoFromProvider(offset, file2, editor);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    @NotNull
    public static final /* synthetic */ String access$capitalizeFirstLetter(@NotNull String $receiver) {
        return PopupActionsKt.capitalizeFirstLetter($receiver);
    }

    public static final /* synthetic */ boolean access$hasDisabledOptionHintInfo(@NotNull InlayParameterHintsProvider $receiver, @NotNull PsiElement element) {
        return PopupActionsKt.hasDisabledOptionHintInfo($receiver, element);
    }

    @NotNull
    public static final /* synthetic */ String access$capitalize(@NotNull String $receiver) {
        return PopupActionsKt.capitalize($receiver);
    }
}

