/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSwitchIntention
extends BaseElementAtCaretIntentionAction {
    public static final String TEXT = "Create switch statement";

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "invoke"));
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class, (boolean)false);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String valueToSwitch = expressionStatement.getExpression().getText();
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)elementFactory.createStatementFromText("switch (" + valueToSwitch + ") {}", null);
        switchStatement = (PsiSwitchStatement)expressionStatement.replace((PsiElement)switchStatement);
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)switchStatement);
        PsiJavaToken lBrace = switchStatement.getBody().getLBrace();
        editor.getCaretModel().moveToOffset(lBrace.getTextOffset() + lBrace.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "isAvailable"));
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class, (boolean)false);
        return expressionStatement != null && expressionStatement.getParent() instanceof PsiCodeBlock && CreateSwitchIntention.isValidTypeForSwitch(expressionStatement.getExpression().getType(), (PsiElement)expressionStatement);
    }

    private static boolean isValidTypeForSwitch(@Nullable PsiType type2, PsiElement context) {
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type2).resolve();
            if (resolvedClass == null) {
                return false;
            }
            return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && resolvedClass.isEnum() || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && "java.lang.String".equals(resolvedClass.getQualifiedName());
        }
        return type2.equals(PsiType.INT) || type2.equals(PsiType.BYTE) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.CHAR);
    }

    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "getFamilyName"));
        }
        return TEXT;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateSwitchIntention", "getText"));
        }
        return string;
    }
}

