/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIfConditionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "isAvailable"));
        }
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null || !(condition2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiType expressionType = polyadicExpression.getType();
        if (expressionType == null || !PsiType.BOOLEAN.isAssignableFrom(expressionType)) {
            return false;
        }
        IElementType operation = polyadicExpression.getOperationTokenType();
        if (operation != JavaTokenType.OROR && operation != JavaTokenType.ANDAND) {
            return false;
        }
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.extract.if.condition.text", (Object[])new Object[]{PsiExpressionTrimRenderer.render((PsiExpression)operand2)}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "invoke"));
        }
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiStatement newIfStatement = ExtractIfConditionAction.create(factory, ifStatement, element);
        if (newIfStatement == null) {
            return;
        }
        ifStatement.replace(codeStyleManager.reformat((PsiElement)newIfStatement));
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement element) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null || !(condition2 instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return null;
        }
        return ExtractIfConditionAction.create(factory, ifStatement.getThenBranch(), ifStatement.getElseBranch(), operand2, ExtractIfConditionAction.removeOperand(factory, polyadicExpression, operand2), polyadicExpression.getOperationTokenType());
    }

    @NotNull
    private static PsiExpression removeOperand(@NotNull PsiElementFactory factory, @NotNull PsiPolyadicExpression expression2, @NotNull PsiExpression operand2) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "removeOperand"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "removeOperand"));
        }
        if (operand2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "removeOperand"));
        }
        StringBuilder sb = new StringBuilder();
        for (PsiExpression e : expression2.getOperands()) {
            if (e == operand2) continue;
            PsiJavaToken token = expression2.getTokenBeforeOperand(e);
            if (token != null && sb.length() != 0) {
                sb.append(token.getText()).append(" ");
            }
            sb.append(e.getText());
        }
        PsiExpression psiExpression = factory.createExpressionFromText(sb.toString(), (PsiElement)expression2);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "removeOperand"));
        }
        return psiExpression;
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @Nullable PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, @NotNull IElementType operation) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        if (extract == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extract", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        if (leave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leave", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "create"));
        }
        if (thenBranch == null) {
            return null;
        }
        if (operation == JavaTokenType.OROR) {
            return ExtractIfConditionAction.createOrOr(factory, thenBranch, elseBranch, extract, leave);
        }
        if (operation == JavaTokenType.ANDAND) {
            return ExtractIfConditionAction.createAndAnd(factory, thenBranch, elseBranch, extract, leave);
        }
        return null;
    }

    @NotNull
    private static PsiStatement createAndAnd(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createAndAnd"));
        }
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createAndAnd"));
        }
        if (extract == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extract", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createAndAnd"));
        }
        if (leave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leave", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createAndAnd"));
        }
        PsiStatement psiStatement = factory.createStatementFromText(ExtractIfConditionAction.createIfString(extract, ExtractIfConditionAction.createIfString(leave, thenBranch, elseBranch), elseBranch), (PsiElement)thenBranch);
        if (psiStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createAndAnd"));
        }
        return psiStatement;
    }

    @NotNull
    private static PsiStatement createOrOr(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createOrOr"));
        }
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createOrOr"));
        }
        if (extract == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extract", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createOrOr"));
        }
        if (leave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leave", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createOrOr"));
        }
        PsiStatement psiStatement = factory.createStatementFromText(ExtractIfConditionAction.createIfString(extract, thenBranch, ExtractIfConditionAction.createIfString(leave, thenBranch, elseBranch)), (PsiElement)thenBranch);
        if (psiStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createOrOr"));
        }
        return psiStatement;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch) {
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        String string = ExtractIfConditionAction.createIfString(condition2.getText(), ExtractIfConditionAction.toThenBranchString(thenBranch), ExtractIfConditionAction.toElseBranchString(elseBranch, false));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable String elseBranch) {
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        String string = ExtractIfConditionAction.createIfString(condition2.getText(), ExtractIfConditionAction.toThenBranchString(thenBranch), elseBranch);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull String thenBranch, @Nullable PsiStatement elseBranch) {
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        String string = ExtractIfConditionAction.createIfString(condition2.getText(), thenBranch, ExtractIfConditionAction.toElseBranchString(elseBranch, true));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull String condition2, @NotNull String thenBranch, @Nullable String elseBranch) {
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        String elsePart = elseBranch != null ? " else " + elseBranch : "";
        String string = "if (" + condition2 + ")\n" + thenBranch + elsePart;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "createIfString"));
        }
        return string;
    }

    @NotNull
    private static String toThenBranchString(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "toThenBranchString"));
        }
        if (!(statement2 instanceof PsiBlockStatement)) {
            String string = "{ " + statement2.getText() + " }";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "toThenBranchString"));
            }
            return string;
        }
        String string = statement2.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "toThenBranchString"));
        }
        return string;
    }

    @Nullable
    private static String toElseBranchString(@Nullable PsiStatement statement2, boolean skipElse) {
        if (statement2 == null) {
            return null;
        }
        if (statement2 instanceof PsiBlockStatement || skipElse && statement2 instanceof PsiIfStatement) {
            return statement2.getText();
        }
        return "{ " + statement2.getText() + " }";
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression2) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "findOperand"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "findOperand"));
        }
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand2 : expression2.getOperands()) {
            TextRange operandTextRange = operand2.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand2;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.extract.if.condition.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction", "getFamilyName"));
        }
        return string;
    }
}

