/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.NotNull;

public class InsertLiteralUnderscoresAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "isAvailable"));
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class, (boolean)false);
        if (literalExpression == null) {
            return false;
        }
        PsiType type2 = literalExpression.getType();
        if (!(PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2))) {
            return false;
        }
        String text2 = literalExpression.getText();
        if (text2 == null || text2.contains("_")) {
            return false;
        }
        String converted = LiteralFormatUtil.format(text2, type2);
        return converted.length() != text2.length();
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiType type2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "invoke"));
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class, (boolean)false);
        if (literalExpression == null) {
            return;
        }
        String text2 = literalExpression.getText();
        String converted = LiteralFormatUtil.format(text2, type2 = literalExpression.getType());
        if (converted.length() == text2.length()) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(converted, null);
        literalExpression.replace((PsiElement)replacement);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.underscores.in.literals.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.insert.literal.underscores", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "getText"));
        }
        return string;
    }
}

