/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching");
    private final List<IntentionAction> myOptionIntentions;
    private final List<IntentionAction> myOptionErrorFixes;
    private final List<IntentionAction> myOptionInspectionFixes;
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this(action, action.getText(), null, null);
    }

    IntentionActionWithTextCaching(@NotNull HighlightInfo.IntentionActionDescriptor descriptor, @Nullable BiConsumer<IntentionActionWithTextCaching, IntentionAction> markInvoked) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this(descriptor.getAction(), descriptor.getDisplayName(), descriptor.getIcon(), markInvoked);
    }

    private IntentionActionWithTextCaching(@NotNull IntentionAction action, String displayName, @Nullable Icon icon, @Nullable BiConsumer<IntentionActionWithTextCaching, IntentionAction> markInvoked) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this.myOptionIntentions = new ArrayList<IntentionAction>();
        this.myOptionErrorFixes = new ArrayList<IntentionAction>();
        this.myOptionInspectionFixes = new ArrayList<IntentionAction>();
        this.myIcon = icon;
        this.myText = action.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action.getClass() + " text returned null"));
        this.myAction = new MyIntentionAction(action, markInvoked);
        this.myDisplayName = displayName;
    }

    @NotNull
    String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getText"));
        }
        return string;
    }

    void addIntention(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addIntention"));
        }
        this.myOptionIntentions.add(action);
    }

    void addErrorFix(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addErrorFix"));
        }
        this.myOptionErrorFixes.add(action);
    }

    void addInspectionFix(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addInspectionFix"));
        }
        this.myOptionInspectionFixes.add(action);
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getAction"));
        }
        return intentionAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        List<IntentionAction> list2 = this.myOptionIntentions;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionIntentions"));
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        List<IntentionAction> list2 = this.myOptionErrorFixes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionErrorFixes"));
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        List<IntentionAction> list2 = this.myOptionInspectionFixes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionInspectionFixes"));
        }
        return list2;
    }

    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "toString"));
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "compareTo"));
        }
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return -((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
    }

    private class MyIntentionAction
    implements IntentionAction,
    IntentionActionDelegate,
    Comparable<MyIntentionAction>,
    ShortcutProvider {
        private final IntentionAction myAction;
        private final BiConsumer<IntentionActionWithTextCaching, IntentionAction> myMarkInvoked;

        MyIntentionAction(IntentionAction action, BiConsumer<IntentionActionWithTextCaching, IntentionAction> markInvoked) {
            this.myAction = action;
            this.myMarkInvoked = markInvoked;
        }

        @Nls
        @NotNull
        public String getText() {
            String string = this.myAction.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "getText"));
            }
            return string;
        }

        public String toString() {
            return this.getDelegate().getClass() + ": " + this.getDelegate();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "isAvailable"));
            }
            return this.myAction.isAvailable(project2, editor, file2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "invoke"));
            }
            try {
                this.myAction.invoke(project2, editor, file2);
            }
            finally {
                if (this.myMarkInvoked != null) {
                    this.myMarkInvoked.accept(IntentionActionWithTextCaching.this, this.myAction);
                }
            }
        }

        public boolean startInWriteAction() {
            return this.myAction.startInWriteAction();
        }

        @NotNull
        public IntentionAction getDelegate() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "getDelegate"));
            }
            return intentionAction;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "getElementToMakeWritable"));
            }
            return this.myAction.getElementToMakeWritable(currentFile);
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
        }

        @Override
        public int compareTo(@NotNull MyIntentionAction other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching$MyIntentionAction", "compareTo"));
            }
            if (this.myAction instanceof Comparable) {
                return ((Comparable)this.myAction).compareTo(other.getDelegate());
            }
            if (other.getDelegate() instanceof Comparable) {
                return -((Comparable)other.getDelegate()).compareTo(this.myAction);
            }
            return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
        }
    }
}

